/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mhfc.net.client.container.ContainerHunterBench;
import mhfc.net.client.gui.ClickableGuiList;
import mhfc.net.client.gui.GuiListItem;
import mhfc.net.client.gui.IMHFCTab;
import mhfc.net.client.gui.MHFCTabbedGui;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.core.registry.MHFCEquipementRecipeRegistry;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;
import mhfc.net.common.item.ItemType;
import mhfc.net.common.tile.TileHunterBench;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class GuiHunterBench
extends MHFCTabbedGui {
    static final int maxHeat = 500;
    static final int modelRectRelX = 228;
    static final int modelRectRelY = 45;
    static final int modelRectW = 124;
    static final int modelRectH = 96;
    public final GuiButton startCrafting;
    public final TileHunterBench tileEntity;
    private static final String[] TAB_NAMES = new String[]{"Armor", "Weapons", "Upgrade", "Weapon tree"};

    public GuiHunterBench(InventoryPlayer par1InventoryPlayer, World par2World, TileHunterBench tileEntity, int x, int y, int z) {
        super(new ContainerHunterBench(par1InventoryPlayer, par2World, tileEntity, x, y, z), TAB_NAMES.length);
        this.tileEntity = tileEntity;
        this.field_146999_f = 374;
        this.field_147000_g = 220;
        this.tabNames = TAB_NAMES;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146294_l = MHFCGuiUtil.minecraftWidth(this.field_146297_k);
        this.field_146295_m = MHFCGuiUtil.minecraftHeight(this.field_146297_k);
        this.field_147003_i = (this.field_146294_l - this.field_146999_f - this.tabWidth) / 2 + this.tabWidth;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.tabList.add(new CraftArmorTab(tileEntity));
        this.tabList.add(new CraftWeaponTab(tileEntity));
        this.tabList.add(new CraftUpgradeTab(tileEntity));
        this.tabList.add(new WeaponTreeTab());
        this.startCrafting = new GuiButton(0, this.field_147003_i + 228 + (this.field_146999_f - 228 - 60) / 2, this.field_147009_r + 166, 40, 20, "Craft"){

            public void func_146118_a(int p_146118_1_, int p_146118_2_) {
                GuiHunterBench.this.tileEntity.beginCrafting();
            }
        };
        this.selectTab();
    }

    protected void selectTab() {
        int type = 2;
        EquipmentRecipe recipe = this.tileEntity.getRecipe();
        if (recipe != null) {
            switch (recipe.getRecipeType()) {
                case ARMOR: {
                    type = 0;
                    break;
                }
                case WEAPON: {
                    type = 1;
                    break;
                }
                case UPGRADE: {
                    type = 2;
                }
                default: {
                    type = 0;
                }
            }
        }
        this.setTab(type);
    }

    private void drawItemModelAndHeat(TileHunterBench bench, float modelRotX, float modelRotY) {
        if (bench != null) {
            ItemStack itemToRender = bench.func_70301_a(1);
            ItemType itemType = ItemType.getTypeOf(itemToRender);
            int rectX = this.field_147003_i + 228;
            int rectY = this.field_147009_r + 45;
            int scale = MHFCGuiUtil.guiScaleFactor(this.field_146297_k);
            this.drawItemModel(itemToRender, rectX, rectY, 124, 96, scale, itemType, modelRotX, modelRotY);
            this.drawBenchOverlay(bench, rectX, rectY, 124);
        }
    }

    private boolean isInModelWindow(int mouseClickRelX, int mouseClickRelY) {
        return mouseClickRelX >= 228 && mouseClickRelX <= 352 && mouseClickRelY >= 45 && mouseClickRelY <= 141;
    }

    private void drawItemModel(ItemStack itemToRender, int rectX, int rectY, int rectW, int rectH, int guiScale, ItemType itemType, float modelRotX, float modelRotY) {
        modelRotX /= 2.0f;
        modelRotY /= 4.0f;
        GL11.glPushMatrix();
        GuiHunterBench.func_73734_a((int)rectX, (int)rectY, (int)(rectX + rectW + 1), (int)(rectY + rectH), (int)-16777216);
        GL11.glScissor((int)(rectX * guiScale), (int)(this.field_146297_k.field_71440_d - rectY * guiScale), (int)(rectW * guiScale), (int)(rectH * guiScale));
        GL11.glEnable((int)3089);
        GL11.glClearDepth((double)1.0);
        GL11.glDisable((int)3089);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        if (itemToRender != null) {
            if (itemType.getGeneralType() == ItemType.GeneralType.ARMOR) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)(rectX + rectW / 2), (float)(rectY + rectH / 2), (float)40.0f);
                switch (itemType) {
                    case ARMOR_HEAD: {
                        GL11.glTranslatef((float)3.0f, (float)15.0f, (float)0.0f);
                        break;
                    }
                    case ARMOR_BODY: {
                        GL11.glTranslatef((float)3.0f, (float)-15.0f, (float)0.0f);
                        break;
                    }
                    case ARMOR_PANTS: {
                        GL11.glTranslatef((float)3.0f, (float)-35.0f, (float)0.0f);
                        break;
                    }
                    case ARMOR_BOOTS: {
                        GL11.glTranslatef((float)3.0f, (float)-55.0f, (float)0.0f);
                        break;
                    }
                }
                GL11.glRotatef((float)modelRotX, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-modelRotY), (float)1.0f, (float)0.0f, (float)0.0f);
                float sc = rectH / 2;
                GL11.glScalef((float)sc, (float)sc, (float)(-sc));
                int armorType = ((ItemArmor)itemToRender.func_77973_b()).field_77881_a;
                ResourceLocation loc = RenderBiped.getArmorResource((Entity)this.field_146297_k.field_71439_g, (ItemStack)itemToRender, (int)armorType, null);
                this.field_146297_k.func_110434_K().func_110577_a(loc);
                ModelBiped model = ForgeHooksClient.getArmorModel((EntityLivingBase)this.field_146297_k.field_71439_g, (ItemStack)itemToRender, (int)armorType, null);
                if (model != null) {
                    model.func_78088_a((Entity)this.field_146297_k.field_71439_g, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06125f);
                    GL11.glFrontFace((int)2304);
                    model.func_78088_a((Entity)this.field_146297_k.field_71439_g, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06125f);
                    GL11.glFrontFace((int)2305);
                }
            } else if (itemType.getGeneralType() == ItemType.GeneralType.WEAPON) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)(rectX + rectW / 2), (float)(rectY + rectH / 2), (float)40.0f);
                GL11.glTranslatef((float)3.0f, (float)-15.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                modelRotY = Math.min(Math.abs(modelRotY), 30.0f) * Math.signum(modelRotY);
                GL11.glRotatef((float)modelRotX, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)modelRotY, (float)0.0f, (float)-1.0f, (float)0.0f);
                float sc = rectH / 8;
                GL11.glScalef((float)sc, (float)(-sc), (float)sc);
                IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemToRender, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
                if (customRenderer != null) {
                    customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, itemToRender, new Object[]{null, Minecraft.func_71410_x().field_71439_g});
                    GL11.glFrontFace((int)2304);
                    customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, itemToRender, new Object[]{null, Minecraft.func_71410_x().field_71439_g});
                    GL11.glFrontFace((int)2305);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void drawBenchOverlay(TileHunterBench bench, int rectX, int rectY, int rectW) {
        int burnHeight = 96;
        int completeWidth = 34;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.HUNTER_BENCH_BURN_BACK);
        int heat = Math.min(bench.getHeatStrength(), 500);
        float burnTexVDiff = (float)heat / 500.0f;
        float burnTexV = 1.0f - burnTexVDiff;
        int burnTexHeight = (int)(burnTexVDiff * 96.0f);
        int burnTexY = rectY + 96 - burnTexHeight;
        MHFCGuiUtil.drawTexturedRectangle(rectX + rectW + 4, burnTexY, 10.0, burnTexHeight, 0.0f, burnTexV, 1.0f, burnTexVDiff);
        if (bench.getRecipe() != null) {
            GL11.glLineWidth((float)1.0f);
            heat = bench.getRecipe().getRequiredHeat();
            heat = Math.min(heat, 500);
            burnTexVDiff = (float)heat / 500.0f;
            burnTexHeight = (int)(burnTexVDiff * 96.0f);
            burnTexY = rectY + 96 - burnTexHeight;
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)1);
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            GL11.glVertex3f((float)(rectX + rectW + 4), (float)((float)burnTexY + 0.7f), (float)this.field_73735_i);
            GL11.glVertex3f((float)(rectX + rectW + 14), (float)((float)burnTexY + 0.7f), (float)this.field_73735_i);
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.HUNTER_BENCH_BURN_TARGET);
        heat = Math.min(TileHunterBench.getItemHeat(bench.func_70301_a(0)), 500);
        if (heat > 0) {
            burnTexVDiff = (float)heat / 500.0f;
            burnTexHeight = (int)(burnTexVDiff * 96.0f);
            burnTexY = rectY + 96 - burnTexHeight;
            MHFCGuiUtil.drawTexturedBoxFromBorder(rectX + rectW + 4, burnTexY - 1, this.field_73735_i, 10.0f, 3.0f, 0.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.HUNTER_BENCH_BURN_FRONT);
        MHFCGuiUtil.drawTexturedBoxFromBorder(rectX + rectW + 4, rectY - 1, this.field_73735_i, 10.0f, 97.0f, 0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.HUNTER_BENCH_FUEL_DURATION);
        float remaining = (float)bench.getHeatLength() / (float)bench.getHeatLengthOriginal();
        if (Float.isInfinite(remaining)) {
            remaining = 0.0f;
        }
        int remain = (int)Math.ceil(remaining * 14.0f);
        remaining = (float)remain / 17.0f;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a((double)(this.field_147003_i + 353), (double)(this.field_147009_r + 159 - remain), (double)this.field_73735_i, 0.0, (double)(0.8235294f - remaining));
        t.func_78374_a((double)(this.field_147003_i + 353), (double)(this.field_147009_r + 159), (double)this.field_73735_i, 0.0, 0.8235294222831726);
        t.func_78374_a((double)(this.field_147003_i + 370), (double)(this.field_147009_r + 159), (double)this.field_73735_i, 1.0, 0.8235294222831726);
        t.func_78374_a((double)(this.field_147003_i + 370), (double)(this.field_147009_r + 159 - remain), (double)this.field_73735_i, 1.0, (double)(0.8235294f - remaining));
        t.func_78381_a();
        if (bench.getRecipe() != null) {
            float completition = (float)bench.getItemSmeltDuration() / (float)bench.getRecipe().getDuration();
            int complete = (int)(completition * 34.0f);
            completition = (float)complete / 34.0f;
            this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.HUNTER_BENCH_COMPLETE);
            MHFCGuiUtil.drawTexturedBoxFromBorder(this.field_147003_i + 298, this.field_147009_r + 145, this.field_73735_i, (int)(completition * 34.0f), 17.0f, 0.0f, 0.0f, completition, 1.0f);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.add(this.startCrafting);
        super.func_73866_w_();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f - this.tabWidth) / 2 + this.tabWidth;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void drawTabBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_BOARD_BACKGROUND);
        int posX = this.field_147003_i;
        int posY = this.field_147009_r;
        MHFCGuiUtil.drawTexturedBoxFromBorder(posX, posY, this.field_73735_i, this.field_146999_f, this.field_147000_g, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.startCrafting.field_146128_h = this.field_147003_i + 228 + (this.field_146999_f - 228 - 60) / 2;
        this.startCrafting.field_146129_i = this.field_147009_r + 166;
    }

    protected class WeaponTreeTab
    implements IMHFCTab {
        private int mouseX = 0;
        private int mouseY = 0;
        private int baseX = 0;
        private int baseY = 0;

        protected WeaponTreeTab() {
        }

        @Override
        public void drawTab(int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
            GuiHunterBench.this.startCrafting.field_146125_m = false;
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            Gui.func_73734_a((int)(GuiHunterBench.this.field_147003_i + 10), (int)(GuiHunterBench.this.field_147009_r + 10), (int)(GuiHunterBench.this.field_147003_i + GuiHunterBench.this.field_146999_f - 10), (int)(GuiHunterBench.this.field_147009_r + GuiHunterBench.this.field_147000_g - 10), (int)-15724528);
            GuiHunterBench.this.func_73732_a(GuiHunterBench.this.field_146289_q, "Not yet implemented", GuiHunterBench.this.field_147003_i + GuiHunterBench.this.field_146999_f / 2 + this.baseX, GuiHunterBench.this.field_147009_r + GuiHunterBench.this.field_147000_g / 2 + this.baseY, 0xAAAAAA);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }

        @Override
        public boolean handleClick(int relativeX, int relativeY, int button) {
            this.mouseX = relativeX;
            this.mouseY = relativeY;
            if (button == 1) {
                this.baseX = 0;
                this.baseY = 0;
            }
            return true;
        }

        @Override
        public boolean containsSlot(Slot slot) {
            return false;
        }

        @Override
        public void updateTab(int pX, int pY) {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onOpen() {
        }

        @Override
        public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
            if (button == 0) {
                this.baseX += mouseX - this.mouseX;
                this.baseY += mouseY - this.mouseY;
            }
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        @Override
        public void handleMouseUp(int mouseX, int mouseY, int button) {
            if (button == 0) {
                this.baseX += mouseX - this.mouseX;
                this.baseY += mouseY - this.mouseY;
            }
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        @Override
        public void handleMovement(int mouseX, int mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }
    }

    protected class CraftUpgradeTab
    extends FilteredRecipeTab {
        public CraftUpgradeTab(TileHunterBench bench) {
            super(bench, EquipmentRecipe.RecipeType.UPGRADE, ItemType.values());
            this.typeList.setItemWidth(20);
        }
    }

    protected class CraftWeaponTab
    extends FilteredRecipeTab {
        public CraftWeaponTab(TileHunterBench bench) {
            super(bench, EquipmentRecipe.RecipeType.WEAPON, ItemType.weaponTypes);
        }
    }

    protected class CraftArmorTab
    extends FilteredRecipeTab {
        public CraftArmorTab(TileHunterBench bench) {
            super(bench, EquipmentRecipe.RecipeType.ARMOR, ItemType.armorTypes);
        }
    }

    protected abstract class FilteredRecipeTab
    extends BenchEntityTab {
        protected EquipmentRecipe.RecipeType recipeType;
        protected ItemType[] itemTypes;
        protected Map<ItemType, Integer> indicesOfTypes;
        protected Map<EquipmentRecipe, Integer> indicesOfRecipes;
        protected ClickableGuiList<TypeItem> typeList;
        protected ClickableGuiList<RecipeItem> recipeList;

        public FilteredRecipeTab(TileHunterBench bench, EquipmentRecipe.RecipeType recipeType, ItemType[] itemTypes) {
            EquipmentRecipe recipe;
            super(bench);
            this.recipeType = recipeType;
            this.itemTypes = itemTypes;
            this.indicesOfRecipes = new HashMap<EquipmentRecipe, Integer>();
            this.indicesOfTypes = new HashMap<ItemType, Integer>();
            this.typeList = new ClickableGuiList(70, GuiHunterBench.this.field_147000_g - 24);
            this.recipeList = new ClickableGuiList(70, GuiHunterBench.this.field_147000_g - 24, 20.0f);
            this.typeList.setAlignment(GuiListItem.Alignment.MIDDLE);
            this.clickableLists.add(this.typeList);
            this.clickableLists.add(this.recipeList);
            this.initializeTypeList();
            if (bench != null && (recipe = bench.getRecipe()) != null) {
                EquipmentRecipe.RecipeType rectype = recipe.getRecipeType();
                ItemType itemtype = recipe.getOutputType();
                Integer selectedIndex = this.indicesOfTypes.get((Object)itemtype);
                this.typeList.setSelected(selectedIndex == null ? -1 : selectedIndex);
                this.listUpdated(this.typeList);
                if (rectype == recipeType) {
                    Integer indexOfRecipe = this.indicesOfRecipes.get(recipe);
                    this.recipeList.setSelected(indexOfRecipe == null ? -1 : indexOfRecipe);
                }
            }
        }

        private void initializeTypeList() {
            for (int i = 0; i < this.itemTypes.length; ++i) {
                this.indicesOfTypes.put(this.itemTypes[i], this.typeList.size());
                this.typeList.add(new TypeItem(this.itemTypes[i]));
            }
        }

        @Override
        protected void listUpdated(ClickableGuiList<?> list) {
            ItemType typeOfSelection = this.getSelectedType();
            if (list == this.typeList) {
                this.recipeList.clear();
                this.fillRecipeList(typeOfSelection);
            } else if (list == this.recipeList) {
                RecipeItem recI = this.recipeList.getSelectedItem();
                this.bench.changeRecipe(recI == null ? null : recI.getRecipe());
            }
        }

        protected ItemType getSelectedType() {
            TypeItem selectedItem = this.typeList.getSelectedItem();
            return selectedItem == null ? ItemType.NO_OTHER : selectedItem.getType();
        }

        @Override
        protected void updateListPositions() {
            this.recipeList.setPosition(153, 12);
            this.typeList.setPosition(78, 12);
        }

        protected void fillRecipeList(ItemType typeOfSelection) {
            Set<EquipmentRecipe> correspondingRecipes = MHFCEquipementRecipeRegistry.getRecipesForType(this.recipeType);
            if (correspondingRecipes == null) {
                return;
            }
            for (EquipmentRecipe rec : correspondingRecipes) {
                if (rec.getOutputType() != typeOfSelection) continue;
                this.indicesOfRecipes.put(rec, this.recipeList.size());
                this.recipeList.add(new RecipeItem(rec));
            }
        }
    }

    protected abstract class BenchEntityTab
    implements IMHFCTab {
        protected TileHunterBench bench;
        protected float modelRotX;
        protected float modelRotY;
        protected int mouseLastX;
        protected int mouseLastY;
        protected int mouseClickX;
        protected int mouseClickY;
        protected int mouseClickButton;
        protected float maxRotation = 50.0f;
        protected List<ClickableGuiList<?>> clickableLists;

        public BenchEntityTab(TileHunterBench bench) {
            this.bench = bench;
            this.clickableLists = new ArrayList();
            this.resetModelRot();
        }

        @Override
        public void drawTab(int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiHunterBench.this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_HUNTERBENCH_BACKGROUND);
            MHFCGuiUtil.drawTexturedBoxFromBorder(posX, posY, GuiHunterBench.this.field_73735_i, GuiHunterBench.this.field_146999_f, GuiHunterBench.this.field_147000_g, 0.0f, 0.0f, 1.0f, 1.0f);
            this.updateListPositions();
            for (ClickableGuiList<?> list : this.clickableLists) {
                list.draw(posX, posY, mousePosX - list.posX, mousePosY - list.posY);
            }
            GuiHunterBench.this.field_146289_q.func_78279_b("Inventory", posX + 6, posY + 12, 500, 0x404040);
            GuiHunterBench.this.startCrafting.field_146125_m = !this.bench.isWorking();
            GuiHunterBench.this.startCrafting.field_146124_l = this.bench.canBeginCrafting();
            GuiHunterBench.this.drawItemModelAndHeat(this.bench, this.modelRotX, this.modelRotY);
        }

        @Override
        public boolean handleClick(int relativeX, int relativeY, int button) {
            this.mouseClickX = relativeX;
            this.mouseClickY = relativeY;
            this.mouseLastX = relativeX;
            this.mouseLastY = relativeY;
            this.mouseClickButton = button;
            if (GuiHunterBench.this.isInModelWindow(this.mouseClickX, this.mouseClickY) && this.mouseClickButton == 1) {
                this.resetModelRot();
            }
            for (ClickableGuiList<?> list : this.clickableLists) {
                if (!list.handleClick(relativeX - list.posX, relativeY - list.posY, button)) continue;
                this.listUpdated(list);
            }
            return true;
        }

        private void resetModelRot() {
            this.modelRotX = -50.0f;
            this.modelRotY = 20.0f;
        }

        protected void listUpdated(ClickableGuiList<?> list) {
        }

        protected void updateListPositions() {
        }

        @Override
        public boolean containsSlot(Slot slot) {
            return slot.field_75224_c == GuiHunterBench.this.tileEntity || slot.field_75224_c instanceof InventoryPlayer && slot.field_75222_d > 51;
        }

        @Override
        public void updateTab(int pX, int pY) {
            this.updateListPositions();
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onOpen() {
            this.bench.refreshState();
        }

        @Override
        public void handleMouseUp(int mouseX, int mouseY, int button) {
            for (ClickableGuiList<?> list : this.clickableLists) {
                list.handleMouseUp(mouseX, mouseY, button);
            }
        }

        @Override
        public void handleMovement(int mouseX, int mouseY) {
            for (ClickableGuiList<?> list : this.clickableLists) {
                list.handleMovement(mouseX, mouseY);
            }
        }

        @Override
        public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
            if (GuiHunterBench.this.isInModelWindow(this.mouseClickX, this.mouseClickY) && this.mouseClickButton == 0) {
                this.modelRotX += (float)(mouseX - this.mouseLastX);
                this.modelRotY += (float)(mouseY - this.mouseLastY);
                if (Math.abs(this.modelRotY) > this.maxRotation) {
                    this.modelRotY = this.maxRotation * Math.signum(this.modelRotY);
                }
            }
            for (ClickableGuiList<?> list : this.clickableLists) {
                list.handleMovementMouseDown(mouseX - list.posX, mouseY - list.posY, button, timeDiff);
            }
            this.mouseLastX = mouseX;
            this.mouseLastY = mouseY;
        }
    }

    public class RecipeItem
    extends GuiListItem {
        String representation;
        EquipmentRecipe recipe;

        public RecipeItem(EquipmentRecipe recipe) {
            this.recipe = recipe;
            this.representation = recipe.func_77571_b().func_82833_r();
        }

        public EquipmentRecipe getRecipe() {
            return this.recipe;
        }

        @Override
        public String getRepresentationString() {
            return this.representation;
        }
    }

    public class TypeItem
    extends GuiListItem {
        ItemType type;

        public TypeItem(ItemType type) {
            this.type = type;
        }

        public ItemType getType() {
            return this.type;
        }

        @Override
        public String getRepresentationString() {
            String str = this.type.getNameString();
            return StatCollector.func_74838_a((String)str);
        }
    }
}

