/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui;

import java.util.ArrayList;
import java.util.List;
import mhfc.net.client.gui.IMHFCTab;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class MHFCTabbedGui
extends GuiContainer {
    protected String[] tabNames;
    protected int tabIndex = 0;
    protected int[] tabDelta;
    protected int tabHeight;
    protected int tabSplit;
    protected int tabWidth;
    protected int tabX;
    protected int tabY;
    protected List<IMHFCTab> tabList;

    public MHFCTabbedGui(Container p_i1072_1_, int tabCount) {
        super(p_i1072_1_);
        this.tabNames = new String[tabCount];
        this.tabDelta = new int[tabCount];
        this.tabHeight = 30;
        this.tabSplit = 1;
        this.tabWidth = 47;
        this.tabList = new ArrayList<IMHFCTab>();
        this.setTab(0);
    }

    protected void func_146976_a(float partialTick, int mousePosX, int mousePosY) {
        int posX = (this.field_146294_l - this.field_146999_f - this.tabWidth) / 2 + this.tabWidth;
        int posY = (this.field_146295_m - this.field_147000_g) / 2;
        this.tabX = posX;
        this.tabY = posY;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        this.drawInactiveTabIcons(posX, posY, mousePosX, mousePosY);
        this.drawTabBackgroundLayer();
        GL11.glEnable((int)2929);
        this.drawTab(this.tabIndex, posX, posY, mousePosX, mousePosY, partialTick);
        this.drawActiveTabIcon(posX, posY, mousePosX, mousePosY);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    protected void drawActiveTabIcon(int posX, int posY, int mouseX, int mouseY) {
        posX += 5;
        posY += 14;
        int diff = this.tabHeight + this.tabSplit;
        int realWidth = 0;
        int i = this.tabIndex;
        GL11.glPushMatrix();
        realWidth = this.tabWidth + this.tabDelta[i];
        this.tabDelta[i] = mouseX >= posX - realWidth && mouseX <= posX && mouseY >= posY + i * diff && mouseY <= posY + i * diff + this.tabHeight ? Math.min(this.tabDelta[i] + 2, 10) : Math.max(this.tabDelta[i] - 2, 0);
        int colorOfTabName = 0x404040;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("mhfc:textures/gui/TabbedGui.png"));
        MHFCGuiUtil.drawTexturedBoxFromBorder(posX - realWidth, posY + i * diff, this.field_73735_i, realWidth, this.tabHeight, 3.0f, 0.03125f, 0.0625f, 1.0f, 1.0f);
        int nameHeight = this.field_146289_q.func_78267_b(this.tabNames[i], this.tabWidth - 2);
        this.field_146289_q.func_78279_b(this.tabNames[i], posX - realWidth + 3, posY + i * diff + (this.tabHeight - nameHeight) / 2, this.tabWidth - 2, colorOfTabName);
        GL11.glPopMatrix();
    }

    protected abstract void drawTabBackgroundLayer();

    protected void drawInactiveTabIcons(int posX, int posY, int mouseX, int mouseY) {
        posX += 5;
        posY += 14;
        int diff = this.tabHeight + this.tabSplit;
        int realWidth = 0;
        for (int i = 0; i < this.tabNames.length; ++i) {
            if (i == this.tabIndex) continue;
            GL11.glPushMatrix();
            realWidth = this.tabWidth + this.tabDelta[i];
            this.tabDelta[i] = mouseX >= posX - realWidth && mouseX <= posX && mouseY >= posY + i * diff && mouseY <= posY + i * diff + this.tabHeight ? Math.min(this.tabDelta[i] + 2, 10) : Math.max(this.tabDelta[i] - 2, 0);
            int colorOfTabName = 0x808080;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("mhfc:textures/gui/TabbedGui.png"));
            MHFCGuiUtil.drawTexturedBoxFromBorder(posX - realWidth, posY + i * diff, this.field_73735_i, realWidth, this.tabHeight, 3.0f, 0.03125f, 0.0625f, 1.0f, 1.0f);
            int nameHeight = this.field_146289_q.func_78267_b(this.tabNames[i], this.tabWidth - 2);
            this.field_146289_q.func_78279_b(this.tabNames[i], posX - realWidth + 3, posY + i * diff + (this.tabHeight - nameHeight) / 2, this.tabWidth - 2, colorOfTabName);
            GL11.glPopMatrix();
        }
    }

    protected void drawTab(int tabIndex, int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
        if (tabIndex >= 0 && tabIndex < this.tabList.size()) {
            this.tabList.get(tabIndex).drawTab(this.tabX, this.tabY, mousePosX - this.tabX, mousePosY - this.tabY, partialTick);
        }
    }

    protected void setTab(int index) {
        if (this.tabIndex >= 0 && this.tabIndex < this.tabList.size()) {
            this.tabList.get(this.tabIndex).onClose();
        }
        if (index >= 0 && index < this.tabList.size()) {
            this.tabIndex = index;
            this.tabList.get(this.tabIndex).onOpen();
        }
        List slots = this.field_147002_h.field_75151_b;
        for (Slot slot : slots) {
            if (index >= 0 && index < this.tabList.size() && this.tabList.get(this.tabIndex).containsSlot(slot)) {
                slot.field_75223_e = Math.abs(slot.field_75223_e + 200) - 200;
                slot.field_75221_f = Math.abs(slot.field_75221_f + 200) - 200;
                continue;
            }
            slot.field_75223_e = -Math.abs(slot.field_75223_e + 200) - 200;
            slot.field_75221_f = -Math.abs(slot.field_75221_f + 200) - 200;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int diff = this.tabHeight + this.tabSplit;
        int realWidth = 0;
        for (int i = 0; i < this.tabNames.length; ++i) {
            realWidth = this.tabWidth + this.tabDelta[i];
            if (mouseX < this.field_147003_i + 3 - realWidth || mouseX > this.field_147003_i + 3 || mouseY < this.field_147009_r + 14 + i * diff || mouseY > this.field_147009_r + 14 + i * diff + this.tabHeight) continue;
            this.setTab(i);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.tabIndex >= 0 && this.tabIndex < this.tabList.size()) {
            this.tabList.get(this.tabIndex).handleClick(mouseX - this.tabX, mouseY - this.tabY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int id) {
        super.func_146286_b(mouseX, mouseY, id);
        if (this.tabIndex >= 0 && this.tabIndex < this.tabList.size()) {
            IMHFCTab tab = this.tabList.get(this.tabIndex);
            if (id < 0) {
                tab.handleMovement(mouseX - this.tabX, mouseY - this.tabY);
            } else {
                tab.handleMouseUp(mouseX - this.tabX, mouseY - this.tabY, id);
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long timeDiff) {
        super.func_146273_a(mouseX, mouseY, button, timeDiff);
        if (this.tabIndex >= 0 && this.tabIndex < this.tabList.size()) {
            this.tabList.get(this.tabIndex).handleMovementMouseDown(mouseX - this.tabX, mouseY - this.tabY, button, timeDiff);
        }
    }

    public List<IMHFCTab> getTabList() {
        return this.tabList;
    }

    public void func_73876_c() {
        IMHFCTab tab = this.tabList.get(this.tabIndex);
        if (tab != null) {
            tab.updateTab(this.tabX, this.tabY);
        }
        super.func_73876_c();
    }

    public void func_146281_b() {
        for (int i = 0; i < this.tabList.size(); ++i) {
            this.tabList.get(i).onClose();
        }
    }
}

