/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui.quests;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import mhfc.net.client.gui.ClickableGuiList;
import mhfc.net.client.gui.IMHFCTab;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageMHFCInteraction;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;

public class GuiQuestJoin
extends GuiScreen
implements IMHFCTab {
    private static final int buttonHeight = 20;
    private static final int yBorder = 15;
    private int runningW = 70;
    private int runningX = 15;
    private ClickableGuiList<ClickableGuiList.GuiListStringItem> runningQuestList = new ClickableGuiList(this.field_146294_l, this.field_146295_m);
    private Map<String, ClickableGuiList.GuiListStringItem> mapToListItems;
    private Map<ClickableGuiList.GuiListStringItem, String> mapToIdentifiers;
    private GuiButton joinQuest;
    private int xPos;
    private int yPos;
    private int xSize = 374;
    private int ySize = 220;
    private int page;
    private boolean clickHandled;

    public GuiQuestJoin(EntityPlayer accessor) {
        this.runningQuestList.setDrawSmallestBounds(false);
        this.runningQuestList.setRecalculateItemHeightOnDraw(false);
        this.runningQuestList.setItemWidth(22);
        this.runningQuestList.setPosition(5 + this.xPos, 20 + this.yPos);
        this.runningQuestList.setWidthAndHeight(70, this.ySize - 30);
        this.mapToListItems = new HashMap<String, ClickableGuiList.GuiListStringItem>();
        this.mapToIdentifiers = new HashMap<ClickableGuiList.GuiListStringItem, String>();
        this.page = 0;
        this.joinQuest = new GuiButton(0, 25, 10, 185 + this.yPos, 20, "Take Quest"){

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    GuiQuestJoin.this.clickHandled = true;
                    ClickableGuiList.GuiListStringItem selectedItem = (ClickableGuiList.GuiListStringItem)GuiQuestJoin.this.runningQuestList.getSelectedItem();
                    if (selectedItem != null) {
                        String questID = (String)GuiQuestJoin.this.mapToIdentifiers.get(selectedItem);
                        if (questID == null) {
                            return true;
                        }
                        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageMHFCInteraction(MessageMHFCInteraction.Interaction.ACCEPT_QUEST, questID));
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public void updateTab(int posX, int posY) {
        this.xPos = posX;
        this.yPos = posY;
        this.runningQuestList.setPosition(this.runningX, 25);
        this.runningQuestList.setWidthAndHeight(this.runningW, this.ySize - 30 - 10);
        this.joinQuest.field_146128_h = (this.xSize - this.runningX - this.runningW - this.joinQuest.func_146117_b()) / 2 + this.runningX + this.runningW + this.xPos;
        this.joinQuest.field_146129_i = this.ySize - 15 - 20 + this.yPos;
    }

    public void func_73876_c() {
        this.xPos = (this.field_146294_l - this.xSize) / 2;
        this.yPos = (this.field_146295_m - this.ySize) / 2;
        this.updateTab(this.xPos, this.yPos);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        String id;
        QuestRunningInformation info;
        this.field_146289_q.func_78276_b("Currently running:", this.xPos + 9, this.yPos + 15, 0x404040);
        this.runningQuestList.setVisible(true);
        this.runningQuestList.draw(this.xPos, this.yPos, mouseX - this.xPos, mouseY - this.yPos);
        this.joinQuest.field_146125_m = true;
        this.joinQuest.field_146124_l = MHFCRegQuestVisual.hasPlayerQuest();
        ClickableGuiList.GuiListStringItem item = this.runningQuestList.getSelectedItem();
        if (item != null && (info = MHFCRegQuestVisual.getRunningInformation(id = this.mapToIdentifiers.get(item))) != null) {
            info.drawInformation(this.xPos + this.runningW + this.runningX, this.yPos + 15, this.xSize - this.runningW - 2 * this.runningX, this.ySize - 30, this.page, this.field_146289_q);
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        this.clickHandled = false;
        super.func_73864_a(mouseX, mouseY, button);
        if (!(this.runningQuestList.handleClick(mouseX - this.xPos - this.runningQuestList.getPosX(), mouseY - this.yPos - this.runningQuestList.getPosY(), button) || MHFCRegQuestVisual.hasPlayerQuest() || mouseX <= this.xPos + 80 || mouseX >= this.xPos + 300 || mouseY <= this.yPos || mouseY >= this.yPos + this.ySize - 30 || this.clickHandled)) {
            this.clickHandled = true;
            int add = button == 0 ? 1 : (button == 1 ? -1 : 0);
            this.page += add;
            this.page = (this.page + 3) % 3;
        }
    }

    public void func_146278_c(int p_146278_1_) {
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_BOARD_BACKGROUND);
        MHFCGuiUtil.drawTexturedBoxFromBorder(this.xPos, this.yPos, this.field_73735_i, this.xSize, this.ySize, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void func_73866_w_() {
        this.xPos = (MHFCGuiUtil.minecraftWidth(this.field_146297_k) - this.xSize) / 2;
        this.yPos = (MHFCGuiUtil.minecraftHeight(this.field_146297_k) - this.ySize) / 2;
        super.func_73866_w_();
        this.field_146292_n.add(this.joinQuest);
        this.func_73876_c();
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void addQuest(String id, QuestRunningInformation info) {
        ClickableGuiList.GuiListStringItem item = new ClickableGuiList.GuiListStringItem(info.getName());
        if (!this.mapToListItems.containsKey(id) && item != null) {
            this.mapToListItems.put(id, item);
            this.mapToIdentifiers.put(item, id);
            this.runningQuestList.add(item);
        }
    }

    public void removeQuest(String id) {
        ClickableGuiList.GuiListStringItem item = this.mapToListItems.get(id);
        this.runningQuestList.remove(item);
        this.mapToListItems.remove(id);
        if (item != null) {
            this.mapToIdentifiers.remove(item);
        }
    }

    public void clearList() {
        this.runningQuestList.clear();
        this.mapToListItems.clear();
    }

    @Override
    public void drawTab(int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
        this.xPos = posX;
        this.yPos = posY;
        this.updateTab(this.xPos, this.yPos);
        this.func_146278_c(0);
        this.func_73863_a(mousePosX + this.xPos, mousePosY + this.yPos, partialTick);
    }

    @Override
    public boolean handleClick(int relativeX, int relativeY, int button) {
        this.func_73864_a(relativeX + this.xPos, relativeY + this.yPos, button);
        return true;
    }

    @Override
    public boolean containsSlot(Slot slot) {
        return false;
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
        this.func_146273_a(mouseX + this.xPos, mouseY + this.yPos, button, timeDiff);
    }

    @Override
    public void handleMouseUp(int mouseX, int mouseY, int id) {
        this.func_146286_b(mouseX + this.xPos, mouseY + this.yPos, id);
    }

    @Override
    public void handleMovement(int mouseX, int mouseY) {
    }
}

