/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui.quests;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import mhfc.net.client.gui.IMHFCTab;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageMHFCInteraction;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;

public class GuiQuestManagement
extends GuiScreen
implements IMHFCTab {
    private static final int startQuestHeight = 20;
    private static final int startQuestWidth = 120;
    private List<Slot> chestSlots;
    private int xPos;
    private int yPos;
    private int xSize;
    private int ySize;
    private GuiButton cancelQuest;
    private GuiButton startQuest;
    private final EntityPlayer accessor;

    public GuiQuestManagement(List<Slot> chestSlots, EntityPlayer player) {
        this.accessor = player;
        this.chestSlots = chestSlots;
        this.xSize = 374;
        this.ySize = 220;
        this.cancelQuest = new GuiButton(0, 25, 10, 120, 20, "Cancel current Quest"){

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    PacketPipeline.networkPipe.sendToServer((IMessage)new MessageMHFCInteraction(MessageMHFCInteraction.Interaction.FORFEIT_QUEST, new String[0]));
                    return true;
                }
                return false;
            }
        };
        this.startQuest = new GuiButton(0, 25, 10, 120, 20, "Set ready status"){
            boolean voted;
            {
                this.voted = MHFCRegQuestVisual.hasPlayerQuest();
            }

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    if (!this.voted) {
                        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageMHFCInteraction(MessageMHFCInteraction.Interaction.START_QUEST, new String[0]));
                        GuiQuestManagement.this.accessor.func_71053_j();
                        this.voted = true;
                    } else {
                        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageMHFCInteraction(MessageMHFCInteraction.Interaction.END_QUEST, new String[0]));
                        this.voted = false;
                    }
                    return true;
                }
                return false;
            }

            public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
                this.field_146126_j = this.voted ? "Unset ready status" : "Set ready status";
                super.func_146112_a(p_146112_1_, p_146112_2_, p_146112_3_);
            }
        };
    }

    public void func_73866_w_() {
        this.field_146292_n.add(this.cancelQuest);
        this.field_146292_n.add(this.startQuest);
        super.func_73866_w_();
    }

    public void func_146278_c(int p_146278_1_) {
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_BOARD_BACKGROUND);
        MHFCGuiUtil.drawTexturedBoxFromBorder(this.xPos, this.yPos, this.field_73735_i, this.xSize, this.ySize, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public void drawTab(int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
        this.xPos = posX;
        this.yPos = posY;
        this.func_73876_c();
        this.func_146278_c(0);
        this.func_73863_a(mousePosX + this.xPos, mousePosY + this.yPos, partialTick);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        String warning = "You are already on a quest";
        int warnX = (this.xSize - this.field_146289_q.func_78256_a(warning)) / 2;
        int warnY = 60;
        this.field_146289_q.func_78276_b(warning, warnX + this.xPos, warnY + this.yPos, 0x404040);
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    @Override
    public boolean handleClick(int relativeX, int relativeY, int button) {
        super.func_73864_a(relativeX + this.xPos, relativeY + this.yPos, button);
        return true;
    }

    @Override
    public boolean containsSlot(Slot slot) {
        if (slot.field_75224_c instanceof InventoryPlayer) {
            return true;
        }
        return this.chestSlots == null ? false : this.chestSlots.contains(slot);
    }

    @Override
    public void updateTab(int posX, int posY) {
        this.cancelQuest.field_146128_h = this.xPos + this.xSize / 2 - this.cancelQuest.func_146117_b() / 2;
        this.cancelQuest.field_146129_i = this.yPos + this.ySize / 2 + 5;
        this.startQuest.field_146128_h = this.xPos + this.xSize / 2 - this.startQuest.func_146117_b() / 2;
        this.startQuest.field_146129_i = this.yPos + this.ySize / 2 - 20 - 10;
    }

    public void func_73876_c() {
        this.xPos = (this.field_146294_l - this.xSize) / 2;
        this.yPos = (this.field_146295_m - this.ySize) / 2;
        this.updateTab(this.xPos, this.yPos);
    }

    @Override
    public void onClose() {
        super.func_146281_b();
    }

    @Override
    public void onOpen() {
        super.func_73866_w_();
    }

    @Override
    public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
    }

    @Override
    public void handleMouseUp(int mouseX, int mouseY, int id) {
        super.func_146286_b(mouseX, mouseY, id);
    }

    @Override
    public void handleMovement(int mouseX, int mouseY) {
    }
}

