/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui.quests;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import mhfc.net.client.gui.ClickableGuiList;
import mhfc.net.client.gui.IMHFCTab;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageMHFCInteraction;
import mhfc.net.common.quests.QuestVisualInformation;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiQuestNew
extends GuiScreen
implements IMHFCTab {
    private static final int buttonHeight = 20;
    private static final int yBorder = 15;
    private int questsW = 70;
    private int questsX = 15;
    private List<String> groupIDsDisplayed = new ArrayList<String>();
    private ClickableGuiList<ClickableGuiList.GuiListStringItem> groupList;
    private GuiButton newQuest;
    private GuiButton left;
    private GuiButton right;
    private List<String> questIdentifiers = new ArrayList<String>();
    private int selectedIdentifier;
    private int xPos;
    private int yPos;
    private int xSize;
    private int ySize;
    private int page = 0;
    private boolean handled;

    public GuiQuestNew(String[] groupIDs, EntityPlayer accessor) {
        int i;
        for (i = 0; i < groupIDs.length; ++i) {
            this.groupIDsDisplayed.add(groupIDs[i]);
        }
        this.groupList = new ClickableGuiList(this.field_146294_l, this.field_146295_m);
        for (i = 0; i < groupIDs.length; ++i) {
            this.groupList.add(new ClickableGuiList.GuiListStringItem(groupIDs[i]));
        }
        this.newQuest = new GuiButton(0, 25, 10, 60, 20, "Take Quest"){

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    GuiQuestNew.this.handled = true;
                    if (GuiQuestNew.this.questIdentifiers != null && GuiQuestNew.this.selectedIdentifier >= 0 && GuiQuestNew.this.selectedIdentifier < GuiQuestNew.this.questIdentifiers.size()) {
                        String questID = (String)GuiQuestNew.this.questIdentifiers.get(GuiQuestNew.this.selectedIdentifier);
                        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageMHFCInteraction(MessageMHFCInteraction.Interaction.NEW_QUEST, questID));
                    }
                    return true;
                }
                return false;
            }
        };
        this.left = new GuiButton(1, 10, 10, 20, 20, "<"){

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    GuiQuestNew.this.handled = true;
                    GuiQuestNew.this.setIdentifier(GuiQuestNew.this.selectedIdentifier - 1);
                    return true;
                }
                return false;
            }
        };
        this.right = new GuiButton(2, 10, 10, 20, 20, ">"){

            public boolean func_146116_c(Minecraft p_146116_1_, int p_146116_2_, int p_146116_3_) {
                if (super.func_146116_c(p_146116_1_, p_146116_2_, p_146116_3_)) {
                    GuiQuestNew.this.handled = true;
                    GuiQuestNew.this.setIdentifier(GuiQuestNew.this.selectedIdentifier + 1);
                    return true;
                }
                return false;
            }
        };
        this.field_146294_l = 374;
        this.field_146295_m = 220;
        this.xSize = 374;
        this.ySize = 220;
    }

    protected void setIdentifier(int i) {
        this.selectedIdentifier = Math.max(Math.min(this.questIdentifiers.size() - 1, i), 0);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        this.handled = false;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.groupList.handleClick(mouseX - this.xPos - this.groupList.getPosX(), mouseY - this.yPos - this.groupList.getPosY(), mouseButton)) {
            this.handled = true;
            ClickableGuiList.GuiListStringItem item = this.groupList.getSelectedItem();
            String selectedList = item == null ? "" : item.getInitializationString();
            this.questIdentifiers.clear();
            List<String> newIdentifiers = MHFCRegQuestVisual.getIdentifierList(selectedList);
            if (newIdentifiers != null) {
                this.questIdentifiers.addAll(newIdentifiers);
            }
        } else if (this.questIdentifiers.size() > 0 && !MHFCRegQuestVisual.hasPlayerQuest() && mouseX > this.xPos + 80 && mouseX < this.xPos + 300 && mouseY > this.yPos && mouseY < this.yPos + this.ySize - 30 && !this.handled) {
            this.handled = true;
            int add = mouseButton == 0 ? 1 : (mouseButton == 1 ? -1 : 0);
            this.page += add;
            this.page = (this.page + 3) % 3;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        this.field_146289_q.func_78276_b("Take a quest:", this.xPos + 8, this.yPos + 15, 0x404040);
        this.groupList.draw(this.xPos, this.yPos, mouseX - this.xPos, mouseY - this.yPos);
        this.left.field_146125_m = true;
        this.right.field_146125_m = true;
        this.newQuest.field_146124_l = false;
        this.newQuest.field_146125_m = true;
        this.left.field_146124_l = this.selectedIdentifier > 0;
        boolean bl = this.right.field_146124_l = this.questIdentifiers != null && this.selectedIdentifier < this.questIdentifiers.size() - 1;
        if (this.questIdentifiers != null && this.selectedIdentifier >= 0 && this.selectedIdentifier < this.questIdentifiers.size()) {
            QuestVisualInformation info = MHFCRegQuestVisual.getVisualInformation(this.questIdentifiers.get(this.selectedIdentifier));
            this.newQuest.field_146124_l = true;
            FontRenderer fontRenderer = this.field_146297_k.field_71466_p;
            if (info != null) {
                info.drawInformation(this.xPos + this.questsX + this.questsW, this.yPos + 15, this.xSize - 2 * this.questsX - this.questsW, this.ySize - 30, this.page, fontRenderer);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
        GL11.glPopMatrix();
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void func_73866_w_() {
        this.field_146292_n.add(this.newQuest);
        this.field_146292_n.add(this.left);
        this.field_146292_n.add(this.right);
        this.func_73876_c();
    }

    @Override
    public void updateTab(int posX, int posY) {
        this.xPos = posX;
        this.yPos = posY;
        this.groupList.setPosition(this.questsX, 25);
        this.groupList.setWidthAndHeight(this.questsW, this.ySize - 30 - 10);
        this.right.field_146128_h = this.xSize - this.questsX - this.right.func_146117_b() + this.xPos;
        this.right.field_146129_i = 15 + this.yPos;
        this.left.field_146128_h = this.questsX + this.questsW + 5 + this.xPos;
        this.left.field_146129_i = 15 + this.yPos;
        this.newQuest.field_146128_h = (this.xSize - this.questsX - this.questsW - this.newQuest.func_146117_b()) / 2 + this.questsX + this.questsW + this.xPos;
        this.newQuest.field_146129_i = this.ySize - 15 - 20 + this.yPos;
    }

    public void func_73876_c() {
        this.xPos = (MHFCGuiUtil.minecraftWidth(this.field_146297_k) - this.xSize) / 2;
        this.yPos = (MHFCGuiUtil.minecraftHeight(this.field_146297_k) - this.ySize) / 2;
        this.updateTab(this.xPos, this.yPos);
        super.func_73876_c();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146278_c(int p_146278_1_) {
        this.field_146297_k.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_BOARD_BACKGROUND);
        MHFCGuiUtil.drawTexturedBoxFromBorder(this.xPos, this.yPos, this.field_73735_i, this.xSize, this.ySize, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @Override
    public void drawTab(int posX, int posY, int mousePosX, int mousePosY, float partialTick) {
        this.xPos = posX;
        this.yPos = posY;
        this.func_73876_c();
        this.func_146278_c(0);
        this.func_73863_a(mousePosX + this.xPos, mousePosY + this.yPos, partialTick);
    }

    @Override
    public boolean handleClick(int relativeX, int relativeY, int button) {
        this.func_73864_a(relativeX + this.xPos, relativeY + this.yPos, button);
        return true;
    }

    @Override
    public boolean containsSlot(Slot slot) {
        return false;
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void handleMovementMouseDown(int mouseX, int mouseY, int button, long timeDiff) {
        this.func_146273_a(mouseX + this.xPos, mouseY + this.yPos, button, timeDiff);
    }

    @Override
    public void handleMouseUp(int mouseX, int mouseY, int id) {
        this.func_146286_b(mouseX + this.xPos, mouseY + this.yPos, id);
    }

    @Override
    public void handleMovement(int mouseX, int mouseY) {
    }
}

