/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.gui.quests;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mhfc.net.client.quests.MHFCRegQuestVisual;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class QuestStatusDisplay
extends Gui {
    private int[] heightFromScale = new int[]{166, 166, 166, 166};
    private Minecraft mc = Minecraft.func_71410_x();
    private int displayTick = 0;

    @SubscribeEvent
    public void onDrawOfGUI(GuiScreenEvent.DrawScreenEvent.Pre screenEvent) {
        QuestRunningInformation information = MHFCRegQuestVisual.getPlayerVisual();
        if (screenEvent.gui instanceof GuiInventory) {
            this.mc.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_STATUS_INVENTORY_BACKGROUND);
            int scale = this.mc.field_71474_y.field_74335_Z & 3;
            if (scale == 0) {
                scale = 3;
            }
            int width = 200;
            int height = this.heightFromScale[scale];
            int scaledWidth = MHFCGuiUtil.minecraftWidth(this.mc);
            int scaledHeight = MHFCGuiUtil.minecraftHeight(this.mc);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int positionX = scaledWidth / 2 + 96;
            int positionY = (scaledHeight - height) / 2;
            width = Math.min(width, scaledWidth - positionX - 10);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
            MHFCGuiUtil.drawTexturedBoxFromBorder(positionX, positionY, this.field_73735_i, width, height, 40.0f, 0.15625f, 0.96875f, 0.6484375f);
            if (information == null) {
                String drawn = "No quest accepted";
                int stringPosY = positionY + (height - this.mc.field_71466_p.field_78288_b) / 2;
                int stringPosX = positionX + (width - this.mc.field_71466_p.func_78256_a(drawn)) / 2;
                this.mc.field_71466_p.func_78276_b(drawn, stringPosX, stringPosY, 0);
            } else {
                if (!this.isMouseOverInfo(positionX, positionY, width, height)) {
                    ++this.displayTick;
                }
                information.drawInformation(positionX, positionY, width, height, this.mc.field_71466_p, this.displayTick);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
        }
    }

    private boolean isMouseOverInfo(int positionX, int positionY, int width, int height) {
        int i = MHFCGuiUtil.minecraftWidth(this.mc);
        int j = MHFCGuiUtil.minecraftWidth(this.mc);
        int k = Mouse.getX() * i / this.mc.field_71443_c;
        int l = j - Mouse.getY() * j / this.mc.field_71440_d - 1;
        return k > positionX && k < positionX + width && l > positionY && l < positionY + height;
    }

    @SubscribeEvent
    public void onDraw(RenderGameOverlayEvent.Post overlayEvent) {
        QuestRunningInformation information = MHFCRegQuestVisual.getPlayerVisual();
        if (overlayEvent.type == RenderGameOverlayEvent.ElementType.FOOD && information != null) {
            this.mc.func_110434_K().func_110577_a(MHFCRegQuestVisual.QUEST_STATUS_ONSCREEN_BACKGROUND);
            GL11.glEnable((int)3042);
            int width = 85;
            int height = 200;
            GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            GL11.glBlendFunc((int)32771, (int)32772);
            int posX = MHFCGuiUtil.minecraftWidth(this.mc) - width;
            int posY = (MHFCGuiUtil.minecraftHeight(this.mc) - height) / 2;
            MHFCGuiUtil.drawTexturedBoxFromBorder(posX, posY, this.field_73735_i, width, height, 40.0f, 0.1171875f, 0.96875f, 0.6484375f);
            GL11.glDisable((int)3042);
            String localizedStat = StatCollector.func_74838_a((String)"mhfc.quests.visual.tag.statusshort");
            this.mc.field_71466_p.func_78276_b(localizedStat, posX + 5, posY + 5, 0x804040);
            int lineHeight = this.mc.field_71466_p.field_78288_b + 2;
            this.mc.field_71466_p.func_78279_b(information.getShortStatus(), posX + 5, posY + lineHeight + 5, width - 10, 0x404040);
        }
    }
}

