/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mhfc.net.client.model.MHFCTransform;
import mhfc.net.client.model.PartTickModelBase;
import mhfc.net.common.interfaces.iMHFC;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class MHFCAnimator {
    private int tempTick = 0;
    private int prevTempTick;
    private boolean correctAnim = false;
    private PartTickModelBase mainModel;
    private iMHFC animEntity;
    private HashMap<ModelRenderer, MHFCTransform> transformMap;
    private HashMap<ModelRenderer, MHFCTransform> prevTransformMap;
    public static final float PI = (float)Math.PI;

    public MHFCAnimator(PartTickModelBase model) {
        this.mainModel = model;
        this.transformMap = new HashMap();
        this.prevTransformMap = new HashMap();
    }

    public iMHFC getEntity() {
        return this.animEntity;
    }

    public void update(iMHFC entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.animEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
        for (int i = 0; i < this.mainModel.field_78092_r.size(); ++i) {
            ModelRenderer box = (ModelRenderer)this.mainModel.field_78092_r.get(i);
            box.field_78795_f = 0.0f;
            box.field_78796_g = 0.0f;
            box.field_78808_h = 0.0f;
        }
    }

    public boolean setAnim(int animID) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.animEntity.getAnimID() == animID;
        return this.correctAnim;
    }

    public void startPhase(int duration) {
        if (!this.correctAnim) {
            return;
        }
        this.prevTempTick = this.tempTick;
        this.tempTick += duration;
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(ModelRenderer box, float x, float y, float z) {
        if (!this.correctAnim) {
            return;
        }
        if (!this.transformMap.containsKey(box)) {
            this.transformMap.put(box, new MHFCTransform(x, y, z));
        } else {
            this.transformMap.get(box).addRot(x, y, z);
        }
    }

    public void move(ModelRenderer box, float x, float y, float z) {
        if (!this.correctAnim) {
            return;
        }
        if (!this.transformMap.containsKey(box)) {
            this.transformMap.put(box, new MHFCTransform(x, y, z, 0.0f, 0.0f, 0.0f));
        } else {
            this.transformMap.get(box).addOffset(x, y, z);
        }
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (!this.correctAnim) {
            return;
        }
        int animTick = this.animEntity.getAnimTick();
        if (animTick >= this.prevTempTick && animTick < this.tempTick) {
            if (stationary) {
                for (ModelRenderer box : this.prevTransformMap.keySet()) {
                    MHFCTransform transform = this.prevTransformMap.get(box);
                    box.field_78795_f += transform.rotX;
                    box.field_78796_g += transform.rotY;
                    box.field_78808_h += transform.rotZ;
                    box.field_78800_c += transform.offsetX;
                    box.field_78797_d += transform.offsetY;
                    box.field_78798_e += transform.offsetZ;
                }
            } else {
                MHFCTransform transform;
                float tick = ((float)(animTick - this.prevTempTick) + this.mainModel.getPartialTick()) / (float)(this.tempTick - this.prevTempTick);
                float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                float dec = 1.0f - inc;
                for (ModelRenderer box : this.prevTransformMap.keySet()) {
                    transform = this.prevTransformMap.get(box);
                    box.field_78795_f += dec * transform.rotX;
                    box.field_78796_g += dec * transform.rotY;
                    box.field_78808_h += dec * transform.rotZ;
                    box.field_78800_c += dec * transform.offsetX;
                    box.field_78797_d += dec * transform.offsetY;
                    box.field_78798_e += dec * transform.offsetZ;
                }
                for (ModelRenderer box : this.transformMap.keySet()) {
                    transform = this.transformMap.get(box);
                    box.field_78795_f += inc * transform.rotX;
                    box.field_78796_g += inc * transform.rotY;
                    box.field_78808_h += inc * transform.rotZ;
                    box.field_78800_c += inc * transform.offsetX;
                    box.field_78797_d += inc * transform.offsetY;
                    box.field_78798_e += inc * transform.offsetZ;
                }
            }
        }
        if (!stationary) {
            this.prevTransformMap.clear();
            this.prevTransformMap.putAll(this.transformMap);
            this.transformMap.clear();
        }
    }
}

