/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.client.quests;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mhfc.net.MHFCMain;
import mhfc.net.client.gui.quests.GuiQuestBoard;
import mhfc.net.client.gui.quests.GuiQuestGiver;
import mhfc.net.client.gui.quests.GuiQuestJoin;
import mhfc.net.client.gui.quests.GuiQuestNew;
import mhfc.net.client.gui.quests.QuestStatusDisplay;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageQuestScreenInit;
import mhfc.net.common.network.packet.MessageQuestVisual;
import mhfc.net.common.network.packet.MessageRequestQuestVisual;
import mhfc.net.common.quests.QuestRunningInformation;
import mhfc.net.common.quests.QuestVisualInformation;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class MHFCRegQuestVisual {
    public static final ResourceLocation QUEST_STATUS_INVENTORY_BACKGROUND = new ResourceLocation("textures/gui/demo_background.png");
    public static final ResourceLocation QUEST_STATUS_ONSCREEN_BACKGROUND = new ResourceLocation("textures/gui/demo_background.png");
    public static final ResourceLocation QUEST_BOARD_BACKGROUND = new ResourceLocation("mhfc:textures/gui/MHFCBackground.png");
    public static final ResourceLocation HUNTER_BENCH_BURN_BACK = new ResourceLocation("mhfc:textures/gui/OvenHeat.png");
    public static final ResourceLocation HUNTER_BENCH_BURN_FRONT = new ResourceLocation("mhfc:textures/gui/OvenBorder.png");
    public static final ResourceLocation HUNTER_BENCH_BURN_TARGET = new ResourceLocation("mhfc:textures/gui/HeatIndicator.png");
    public static final ResourceLocation QUEST_HUNTERBENCH_BACKGROUND = new ResourceLocation("mhfc:textures/gui/MHFCCraftStation.png");
    public static final ResourceLocation HUNTER_BENCH_COMPLETE = new ResourceLocation("mhfc:textures/gui/ProgArrow.png");
    public static final ResourceLocation HUNTER_BENCH_FUEL_DURATION = new ResourceLocation("mhfc:textures/gui/ProgFlame.png");
    public static final ResourceLocation CLICKABLE_LIST = new ResourceLocation("mhfc:textures/gui/GuiList.png");
    private static Map<String, List<String>> groupIDToListMap = new HashMap<String, List<String>>();
    private static List<String> groupIDsInOrder = new ArrayList<String>();
    private static Set<String> runningQuestIDs = new HashSet<String>();
    private static Map<String, QuestVisualInformation> identifierToVisualInformationMap = new HashMap<String, QuestVisualInformation>();
    private static Map<String, QuestRunningInformation> identifierToVisualRunningMap = new HashMap<String, QuestRunningInformation>();
    @SideOnly(value=Side.CLIENT)
    private static QuestStatusDisplay display;
    @SideOnly(value=Side.CLIENT)
    private static GuiQuestJoin questBoard;
    private static boolean hasPlayerQuest;
    private static QuestRunningInformation playersVisual;

    private static QuestVisualInformation getInformationFromMessage(MessageQuestVisual message) {
        String[] strings = message.getStrings();
        String name = strings[1];
        if ("".equals(name)) {
            return null;
        }
        String description = strings[2];
        String client = strings[3];
        String aims = strings[4];
        String fails = strings[5];
        String areaNameID = strings[6];
        String timeLimitInS = strings[7];
        String type = strings[8];
        String reward = strings[9];
        String fee = strings[10];
        String maxPartySize = strings[11];
        QuestVisualInformation.QuestType realType = null;
        switch (type) {
            case "mhfc.quests.type.killing": {
                realType = QuestVisualInformation.QuestType.Killing;
                break;
            }
            case "mhfc.quests.type.hunting": {
                realType = QuestVisualInformation.QuestType.Hunting;
                break;
            }
            case "mhfc.quests.type.epichunting": {
                realType = QuestVisualInformation.QuestType.EpicHunting;
                break;
            }
            case "mhfc.quests.type.gathering": {
                realType = QuestVisualInformation.QuestType.Gathering;
                break;
            }
        }
        QuestVisualInformation visual = new QuestVisualInformation(name, description, client, aims, fails, areaNameID, timeLimitInS, reward, fee, maxPartySize, realType);
        return visual;
    }

    private static void modifyVisualOfIdentifier(QuestVisualInformation visual, MessageQuestVisual message) {
        String identifier = message.getStrings()[0];
        identifierToVisualInformationMap.put(identifier, visual);
    }

    private static void setPlayerVisual(QuestVisualInformation visual, MessageQuestVisual message) {
        String[] strings = message.getStrings();
        hasPlayerQuest = visual != null;
        QuestRunningInformation runInfo = new QuestRunningInformation(visual, strings[12], strings[13]);
        if (playersVisual != null) {
            playersVisual.cleanUp();
        }
        playersVisual = !hasPlayerQuest ? null : runInfo;
    }

    private static void modifyRunningQuestList(QuestVisualInformation visual, MessageQuestVisual message) {
        String[] strings = message.getStrings();
        String identifier = strings[0];
        boolean clear = visual == null;
        QuestRunningInformation runInfo = new QuestRunningInformation(visual, strings[12], strings[13]);
        if (clear) {
            identifierToVisualRunningMap.remove(identifier);
            runningQuestIDs.remove(identifier);
            questBoard.removeQuest(identifier);
        } else {
            identifierToVisualRunningMap.put(identifier, runInfo);
            runningQuestIDs.add(identifier);
            questBoard.addQuest(identifier, runInfo);
        }
    }

    public static GuiQuestGiver getScreen(int i, EntityPlayer playerEntity) {
        if (i < 0 || i >= groupIDToListMap.size()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(groupIDToListMap.keySet());
        GuiQuestNew newQuest = new GuiQuestNew(list.toArray(new String[0]), playerEntity);
        return new GuiQuestGiver(playerEntity, newQuest);
    }

    public static List<String> getIdentifierList(String groupId) {
        return groupIDToListMap.get(groupId);
    }

    public static Set<String> getRunningQuestIDs() {
        return runningQuestIDs;
    }

    public static QuestVisualInformation getVisualInformation(String identifier) {
        if (identifierToVisualInformationMap.containsKey(identifier)) {
            return identifierToVisualInformationMap.get(identifier);
        }
        PacketPipeline.networkPipe.sendToServer((IMessage)new MessageRequestQuestVisual(identifier));
        identifierToVisualInformationMap.put(identifier, QuestVisualInformation.LOADING_REPLACEMENT);
        return QuestVisualInformation.LOADING_REPLACEMENT;
    }

    public static QuestRunningInformation getRunningInformation(String identifier) {
        return identifierToVisualRunningMap.get(identifier);
    }

    public static boolean hasPlayerQuest() {
        return hasPlayerQuest;
    }

    public static void init() {
        display = new QuestStatusDisplay();
        MinecraftForge.EVENT_BUS.register((Object)display);
    }

    public static QuestRunningInformation getPlayerVisual() {
        return playersVisual;
    }

    public static GuiQuestBoard getQuestBoard(EntityPlayer player) {
        return new GuiQuestBoard(questBoard, player);
    }

    static {
        questBoard = new GuiQuestJoin((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        hasPlayerQuest = false;
    }

    public static class QuestScreenVisualHandler
    implements IMessageHandler<MessageQuestVisual, IMessage> {
        public IMessage onMessage(MessageQuestVisual message, MessageContext ctx) {
            QuestVisualInformation visual = MHFCRegQuestVisual.getInformationFromMessage(message);
            switch (message.getTypeID()) {
                case 0: {
                    MHFCRegQuestVisual.modifyVisualOfIdentifier(visual, message);
                    break;
                }
                case 1: {
                    MHFCRegQuestVisual.setPlayerVisual(visual, message);
                    break;
                }
                case 2: {
                    MHFCRegQuestVisual.modifyRunningQuestList(visual, message);
                }
            }
            return null;
        }
    }

    public static class QuestVisualInitHandler
    implements IMessageHandler<MessageQuestScreenInit, IMessage> {
        public IMessage onMessage(MessageQuestScreenInit message, MessageContext ctx) {
            Map<String, List<String>> identifierLists = message.getIdentifierListMap();
            List<String> identifiers = message.getIdentifiers();
            groupIDsInOrder = identifiers;
            groupIDToListMap = identifierLists;
            MHFCMain.logger.debug("Client received quest info");
            return null;
        }
    }
}

