/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mhfc.net.MHFCMain;
import mhfc.net.common.ai.IActionManager;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.IManagedActions;
import mhfc.net.common.ai.general.WeightedPick;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.message.MessageAIAttack;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;

public class AIActionManager<EntType extends EntityLiving>
extends EntityAIBase
implements IActionManager<EntType> {
    protected final List<IExecutableAction<? super EntType>> attacks = new ArrayList<IExecutableAction<? super EntType>>();
    protected IExecutableAction<? super EntType> activeAttack = null;
    protected EntType entity;

    public AIActionManager(EntType entity) {
        this.entity = (EntityLiving)Objects.requireNonNull(entity, "Entity can't be null");
    }

    @SideOnly(value=Side.CLIENT)
    public void setAttack(int index) {
        this.swapAttacks(this.activeAttack, index < 0 ? null : this.attacks.get(index));
    }

    @Override
    public IExecutableAction<? super EntType> chooseAttack() {
        return WeightedPick.pickRandom(this.attacks);
    }

    public boolean func_75250_a() {
        this.activeAttack = this.chooseAttack();
        if (this.activeAttack == null) {
            MHFCMain.logger.debug("Did not choose any attack, not executing");
        }
        return this.activeAttack != null;
    }

    protected void sendUpdate() {
        if (!((EntityLiving)this.entity).field_70170_p.field_72995_K) {
            PacketPipeline.networkPipe.sendToAll(new MessageAIAttack<EntType>(this.entity, this.attacks.indexOf(this.activeAttack)));
        }
    }

    protected void swapAttacks(IExecutableAction<? super EntType> oldAttack, IExecutableAction<? super EntType> newAttack) {
        ((IManagedActions)this.entity).onAttackEnd(oldAttack);
        if (oldAttack != null) {
            oldAttack.finishAction();
        }
        this.activeAttack = newAttack;
        ((IManagedActions)this.entity).onAttackStart(newAttack);
        if (newAttack != null) {
            newAttack.beginAction();
        }
        this.sendUpdate();
    }

    public void func_75249_e() {
        this.swapAttacks(null, this.activeAttack);
    }

    public boolean func_75253_b() {
        if (this.activeAttack.shouldContinue()) {
            return true;
        }
        return this.executeNextAttack();
    }

    protected boolean executeNextAttack() {
        IExecutableAction<EntType> nextAttack = this.chooseAttack();
        if (nextAttack == null) {
            return false;
        }
        this.swapAttacks(this.activeAttack, nextAttack);
        return true;
    }

    public void func_75251_c() {
        this.swapAttacks(this.activeAttack, null);
    }

    public void func_75246_d() {
        this.activeAttack.updateAction();
    }

    public int func_75247_h() {
        return this.activeAttack == null ? 0 : (int)this.activeAttack.mutexBits();
    }

    @Override
    public void registerAttack(IExecutableAction<? super EntType> attack) {
        Objects.requireNonNull(attack);
        attack.rebind(this.entity);
        this.attacks.add(attack);
    }

    @Override
    public IAnimation getCurrentAnimation() {
        return this.activeAttack == null ? null : this.activeAttack.getCurrentAnimation();
    }

    @Override
    public int getCurrentFrame() {
        return this.activeAttack == null ? -1 : this.activeAttack.getCurrentFrame();
    }
}

