/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai;

import java.util.Objects;
import mhfc.net.common.ai.AIActionManager;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.IManagedActions;
import mhfc.net.common.ai.IStancedActionManager;
import net.minecraft.entity.EntityLiving;

public class AIStancedActionManager<EntityT extends EntityLiving, StanceT extends Enum<StanceT>>
extends AIActionManager<EntityT>
implements IStancedActionManager<EntityT, StanceT> {
    protected StanceT currentStance;
    protected StanceT nextStance;

    public AIStancedActionManager(EntityT entity, StanceT initalStance) {
        super(entity);
        Objects.requireNonNull(initalStance);
        this.nextStance = initalStance;
        this.currentStance = this.nextStance;
    }

    @Override
    public void setNextStance(StanceT newMode) {
        this.nextStance = newMode;
    }

    @Override
    protected boolean executeNextAttack() {
        ((IStancedActionManager.Stance)this.currentStance).onAttackEnd(this.activeAttack, this.entity);
        this.swapStances();
        boolean hasAttack = super.executeNextAttack();
        if (hasAttack) {
            ((IStancedActionManager.Stance)this.currentStance).onAttackStart(this.activeAttack, this.entity);
        }
        return hasAttack;
    }

    protected void swapStances() {
        if (this.currentStance != null) {
            ((IStancedActionManager.Stance)this.currentStance).onStanceEnd();
        }
        this.currentStance = this.nextStance;
        if (this.currentStance != null) {
            ((IStancedActionManager.Stance)this.currentStance).onStanceStart();
        }
    }

    @Override
    protected void swapAttacks(IExecutableAction<? super EntityT> oldAttack, IExecutableAction<? super EntityT> newAttack) {
        ((IManagedActions)this.entity).onAttackEnd(oldAttack);
        if (oldAttack != null) {
            oldAttack.finishAction();
        }
        this.activeAttack = newAttack;
        ((IManagedActions)this.entity).onAttackStart(newAttack);
        if (newAttack != null) {
            newAttack.beginAction();
        }
        this.sendUpdate();
    }

    @Override
    public StanceT getCurrentStance() {
        return this.currentStance;
    }

    @Override
    public IExecutableAction<? super EntityT> chooseAttack() {
        IExecutableAction attack = super.chooseAttack();
        return attack;
    }
}

