/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.util.AnimationLoader;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.eventhandler.ai.ActionSelectionEvent;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public abstract class ActionAdapter<T extends EntityCreature>
implements IExecutableAction<T> {
    private static final Random rand = new Random();
    private IAnimation animation;
    private int framesPassed;
    private int recentFrame;
    private int lastFrame = -2;
    private T entity;
    protected EntityLivingBase target;
    protected AIUtils.DamageCalculatorHelper dmgHelper = new AIUtils.DamageCalculatorHelper();

    @Override
    public void beginAction() {
        this.framesPassed = 0;
        this.recentFrame = -1;
        this.dmgHelper.reset();
        FMLCommonHandler.instance().bus().post((Event)new ActionSelectionEvent(this, (EntityLivingBase)this.getEntity()));
        this.beginExecution();
    }

    @Override
    public void finishAction() {
        this.finishExecution();
    }

    @Override
    public void updateAction() {
        this.setToNextFrame(this.getCurrentFrame() + 1);
        ++this.framesPassed;
        this.update();
    }

    protected void beginExecution() {
    }

    protected void finishExecution() {
    }

    protected abstract void update();

    @Override
    public abstract float getWeight();

    protected T getEntity() {
        return this.entity;
    }

    protected Random rng() {
        if (this.entity == null || ((EntityCreature)this.entity).field_70170_p == null) {
            return rand;
        }
        return ((EntityCreature)this.entity).field_70170_p.field_73012_v;
    }

    protected void setAnimation(IAnimation anim) {
        this.animation = anim;
    }

    protected void setAnimation(ResourceLocation resLoc) {
        this.animation = AnimationLoader.loadAnimation((ResourceLocation)resLoc);
    }

    protected void setAnimation(String resLoc) {
        this.animation = AnimationLoader.loadAnimation((String)resLoc);
    }

    protected void setLastFrame(int lastFrame) {
        this.lastFrame = lastFrame;
    }

    @Override
    public IAnimation getCurrentAnimation() {
        return this.animation;
    }

    @Override
    public void rebind(T entity) {
        this.entity = entity;
    }

    @Override
    public boolean forceSelection() {
        return false;
    }

    @Override
    public byte mutexBits() {
        return 7;
    }

    public int setToNextFrame(int frame) {
        this.recentFrame = frame;
        return this.recentFrame;
    }

    @Override
    public int getCurrentFrame() {
        return this.recentFrame;
    }

    @Override
    public boolean shouldContinue() {
        return this.getCurrentFrame() < this.lastFrame;
    }

    public int getFramesPased() {
        return this.framesPassed;
    }
}

