/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai;

import java.util.ArrayList;
import java.util.List;
import mhfc.net.common.ai.IExecutableAction;
import net.minecraft.entity.EntityLivingBase;

public interface IActionRecorder<EntityT extends EntityLivingBase> {
    public List<IExecutableAction<? super EntityT>> getActionHistory();

    public IExecutableAction<? super EntityT> getLastAction();

    public static class RecorderAdapter<EntityT extends EntityLivingBase>
    implements IActionRecorder<EntityT> {
        private List<IExecutableAction<? super EntityT>> actionHistory;
        private int maximum;

        public RecorderAdapter(int historyLength) {
            this.maximum = historyLength;
            this.actionHistory = new ArrayList<IExecutableAction<? super EntityT>>();
        }

        public void addAction(IExecutableAction<? super EntityT> action) {
            this.actionHistory.add(action);
            int length = this.actionHistory.size();
            if (length > this.maximum) {
                this.actionHistory.subList(0, length - this.maximum).clear();
            }
        }

        @Override
        public List<IExecutableAction<? super EntityT>> getActionHistory() {
            return this.actionHistory;
        }

        @Override
        public IExecutableAction<? super EntityT> getLastAction() {
            int size = this.actionHistory.size();
            return size > 0 ? this.actionHistory.get(size - 1) : null;
        }
    }
}

