/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.entity.deviljho;

import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.entity.monster.EntityDeviljho;
import mhfc.net.common.util.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.Vec3;

public class DeviljhoMovetoTarget
extends ActionAdapter<EntityDeviljho> {
    private static final int runningStarts = 5;
    private static final int runningEnds = 40;
    private static final int attackEnd = 40;
    private static final float TURN_RATE_INITIAL = 20.5f;
    private static final float TURN_RATE_DURING_RUN = 1.05f;
    private static final float MAX_RUN_DISTANCE = 20.0f;
    private static final int MAX_RUN_FRAMES = 200;
    private static final double RUN_SPEED = 0.6;
    private static final double STOP_SPEED = 0.4;
    private static final AIUtils.IDamageCalculator damageCalc = AIUtils.defaultDamageCalc(47.0f, 92.0f, 1000.0f);
    private static final double MAX_DIST = 3.0;
    private AttackPhase currentPhase;
    private PastEntityEnum hasPassed;
    private Vec3 runStartPoint;
    private int framesRunning;
    private int runCycles;

    public DeviljhoMovetoTarget() {
        this.setAnimation("mhfc:models/Deviljho/DeviljhoWalk.mcanm");
    }

    @Override
    public float getWeight() {
        EntityDeviljho monster = (EntityDeviljho)this.getEntity();
        this.target = monster.func_70638_az();
        if (this.target == null) {
            return 0.0f;
        }
        Vec3 toTarget = WorldHelper.getVectorToTarget((Entity)monster, (Entity)this.target);
        double dist = toTarget.func_72433_c();
        if (dist < 3.0) {
            return 0.0f;
        }
        return (float)Math.log(dist / 5.0 + 1.0);
    }

    @Override
    public void beginExecution() {
        EntityDeviljho mob = (EntityDeviljho)this.getEntity();
        this.target = mob.func_70638_az();
        mob.func_85030_a("mhfc:deviljho-roar", 1.0f, 1.0f);
        this.currentPhase = AttackPhase.START;
        this.hasPassed = PastEntityEnum.NOT_PASSED;
        this.runCycles = 0;
        this.framesRunning = 0;
        this.currentPhase.onPhaseStart(this);
        this.runStartPoint = Vec3.func_72443_a((double)mob.field_70165_t, (double)mob.field_70163_u, (double)mob.field_70161_v);
    }

    @Override
    public void update() {
        AttackPhase nextPhase;
        this.currentPhase.update(this);
        if (this.currentPhase.isDamaging) {
            AIUtils.damageCollidingEntities(this.getEntity(), damageCalc);
        }
        if (this.currentPhase != (nextPhase = this.currentPhase.next(this))) {
            nextPhase.onPhaseStart(this);
            this.currentPhase = nextPhase;
        }
    }

    @Override
    public boolean shouldContinue() {
        return this.currentPhase != AttackPhase.STOPPED;
    }

    @Override
    public void finishExecution() {
    }

    @Override
    public byte mutexBits() {
        return 1;
    }

    @Override
    public int setToNextFrame(int frame) {
        return super.setToNextFrame(this.currentPhase.nextFrame(this, frame));
    }

    private static enum AttackPhase {
        START(false){

            @Override
            public void onPhaseStart(DeviljhoMovetoTarget attk) {
                EntityDeviljho monster = (EntityDeviljho)attk.getEntity();
                monster.field_70179_y = 0.0;
                monster.field_70181_x = 0.0;
                monster.field_70159_w = 0.0;
                monster.getTurnHelper().updateTurnSpeed(20.5f);
                ((EntityDeviljho)attk.getEntity()).getTurnHelper().updateTargetPoint((Entity)attk.target);
            }

            @Override
            public void update(DeviljhoMovetoTarget attk) {
                ((EntityDeviljho)attk.getEntity()).getTurnHelper().forceUpdate();
            }

            @Override
            public AttackPhase next(DeviljhoMovetoTarget attk) {
                if (attk.target == null) {
                    return STOPPED;
                }
                if (attk.getCurrentFrame() < 5) {
                    return START;
                }
                return RUNNING;
            }
        }
        ,
        RUNNING(true){

            @Override
            public void onPhaseStart(DeviljhoMovetoTarget attk) {
                ((EntityDeviljho)attk.getEntity()).getTurnHelper().updateTurnSpeed(1.05f);
                attk.framesRunning = 0;
            }

            @Override
            public void update(DeviljhoMovetoTarget attk) {
                boolean ranLongEnough;
                EntityDeviljho monster = (EntityDeviljho)attk.getEntity();
                Vec3 mobPos = Vec3.func_72443_a((double)monster.field_70165_t, (double)monster.field_70163_u, (double)monster.field_70161_v);
                Vec3 vecToTarget = mobPos.func_72444_a(attk.target.func_70666_h(1.0f));
                monster.getTurnHelper().updateTargetPoint((Entity)attk.target);
                monster.moveForward(0.6, true);
                Vec3 look = monster.func_70040_Z();
                boolean tarBeh = vecToTarget.func_72432_b().func_72430_b(look) < 0.0;
                boolean bl = ranLongEnough = attk.runStartPoint.func_72444_a(mobPos).func_72433_c() > 20.0 || attk.framesRunning > 200;
                if ((tarBeh || ranLongEnough) && attk.hasPassed == PastEntityEnum.NOT_PASSED) {
                    attk.hasPassed = PastEntityEnum.PASSED;
                }
            }

            @Override
            public AttackPhase next(DeviljhoMovetoTarget attk) {
                if (attk.hasPassed == PastEntityEnum.LOOP_FINISHED) {
                    return STOPPING;
                }
                return RUNNING;
            }

            @Override
            public int nextFrame(DeviljhoMovetoTarget attk, int curr) {
                attk.framesRunning++;
                int looping = 35;
                if (attk.hasPassed == PastEntityEnum.PASSED && curr + 1 >= 40) {
                    attk.hasPassed = PastEntityEnum.LOOP_FINISHED;
                }
                return 5 + (curr + 1 - 5) % looping;
            }
        }
        ,
        STOPPING(true){

            @Override
            public void update(DeviljhoMovetoTarget attk) {
                EntityDeviljho e = (EntityDeviljho)attk.getEntity();
                e.moveForward(0.4, false);
            }

            @Override
            public AttackPhase next(DeviljhoMovetoTarget attk) {
                if (40 < attk.getCurrentFrame()) {
                    return STOPPED;
                }
                return STOPPING;
            }
        }
        ,
        STOPPED(false){

            @Override
            public void onPhaseStart(DeviljhoMovetoTarget attk) {
                EntityCreature entity = attk.getEntity();
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
            }
        };

        public final boolean isDamaging;

        private AttackPhase(boolean isDamaging) {
            this.isDamaging = isDamaging;
        }

        public void onPhaseStart(DeviljhoMovetoTarget attk) {
        }

        public void update(DeviljhoMovetoTarget attk) {
        }

        public AttackPhase next(DeviljhoMovetoTarget attk) {
            return this;
        }

        public int nextFrame(DeviljhoMovetoTarget attk, int curr) {
            return ++curr;
        }
    }

    private static enum PastEntityEnum {
        NOT_PASSED,
        PASSED,
        LOOP_FINISHED,
        TURNING;

    }
}

