/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.entity.nargacuga;

import java.util.Objects;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.actions.AIGeneralJumpAttack;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IDamageProvider;
import mhfc.net.common.ai.general.provider.IJumpParamterProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.monster.EntityNargacuga;

public final class NargacugaPounce
extends AIGeneralJumpAttack<EntityNargacuga> {
    private static final int TURN_SLOW = 2;
    private static final int TURN_FAST = 10;
    private static final float WEIGHT = 3.0f;
    private static final AIUtils.IDamageCalculator dmgCalculator = AIUtils.defaultDamageCalc(28.0f, 300.0f, 5000.0f);
    private JumpVariation variation;

    public static NargacugaPounce createNargaPounce() {
        NargacugaPounce pounce;
        IAnimationProvider.AnimationAdapter animation = new IAnimationProvider.AnimationAdapter("", 5);
        ISelectionPredicate.SelectAlways<EntityNargacuga> select = new ISelectionPredicate.SelectAlways<EntityNargacuga>();
        IWeightProvider.SimpleWeightAdapter<EntityNargacuga> weight = new IWeightProvider.SimpleWeightAdapter<EntityNargacuga>(3.0f);
        IDamageProvider.DamageAdapter damage = new IDamageProvider.DamageAdapter(dmgCalculator);
        NargaJumpAdapter adapter = new NargaJumpAdapter(animation, select, weight, damage);
        NargacugaPounce nargacugaPounce = pounce = new NargacugaPounce(adapter);
        nargacugaPounce.getClass();
        adapter.setDynamicTimingAdapter(nargacugaPounce.new NargaJumpTiming());
        adapter.setDynamicJumpParameterAdapter(pounce.new NargaJumpParameter());
        return pounce;
    }

    private NargacugaPounce(AIGeneralJumpAttack.IJumpProvider<EntityNargacuga> provider) {
        super(provider);
    }

    private void chooseAttackIterations() {
        this.variation = ((EntityNargacuga)this.getEntity()).isEnraged() ? JumpVariation.FourJumps : JumpVariation.TwoJumps;
        this.setAnimation(this.variation.getAnimation());
    }

    @Override
    public void beginExecution() {
        super.beginExecution();
        this.chooseAttackIterations();
        this.setToNextFrame(17);
    }

    private static enum JumpVariation implements AIGeneralJumpAttack.IJumpTimingProvider<EntityNargacuga>
    {
        TwoJumps{
            private final int JUMP_TIME = 10;
            private final int JUMP1_FRAME = 28;
            private final int LAND1_FRAME = 38;
            private final int JUMP2_FRAME = 47;
            private final int LAND2_FRAME = 57;

            @Override
            public boolean isJumpFrame(EntityNargacuga entity, int frame) {
                return frame == 28 || frame == 47;
            }

            @Override
            public boolean isDamageFrame(EntityNargacuga entity, int frame) {
                return frame > 28;
            }

            @Override
            public float getTurnRate(EntityNargacuga entity, int frame) {
                if (frame < 28) {
                    return 2.0f;
                }
                if (frame > 38 && frame < 47) {
                    return 2.0f;
                }
                return 10.0f;
            }

            @Override
            public String getAnimation() {
                return "mhfc:models/Nargacuga/Pounce.mcanm";
            }

            @Override
            public int getAirTime(int frame) {
                return 10;
            }
        }
        ,
        ThreeJumps{

            @Override
            public boolean isJumpFrame(EntityNargacuga entity, int frame) {
                return false;
            }

            @Override
            public boolean isDamageFrame(EntityNargacuga entity, int frame) {
                return false;
            }

            @Override
            public float getTurnRate(EntityNargacuga entity, int frame) {
                return 0.0f;
            }

            @Override
            public String getAnimation() {
                return null;
            }

            @Override
            public int getAirTime(int frame) {
                return 0;
            }
        }
        ,
        FourJumps{

            @Override
            public boolean isJumpFrame(EntityNargacuga entity, int frame) {
                return false;
            }

            @Override
            public boolean isDamageFrame(EntityNargacuga entity, int frame) {
                return false;
            }

            @Override
            public float getTurnRate(EntityNargacuga entity, int frame) {
                return 0.0f;
            }

            @Override
            public String getAnimation() {
                return null;
            }

            @Override
            public int getAirTime(int frame) {
                return 0;
            }
        };


        public abstract String getAnimation();

        public abstract int getAirTime(int var1);
    }

    private class NargaJumpParameter
    extends IJumpParamterProvider.AttackTargetAdapter<EntityNargacuga> {
        public NargaJumpParameter() {
            super(1.0f);
        }

        private void updateAirTime() {
            this.airTime = NargacugaPounce.this.variation.getAirTime(NargacugaPounce.this.getCurrentFrame());
        }

        @Override
        public float getForwardVelocity(EntityNargacuga entity) {
            this.updateAirTime();
            return super.getForwardVelocity(entity);
        }

        @Override
        public float getInitialUpVelocity(EntityNargacuga entity) {
            this.updateAirTime();
            return super.getInitialUpVelocity(entity);
        }
    }

    private class NargaJumpTiming
    implements AIGeneralJumpAttack.IJumpTimingProvider<EntityNargacuga> {
        private NargaJumpTiming() {
        }

        @Override
        public boolean isJumpFrame(EntityNargacuga entity, int frame) {
            return NargacugaPounce.this.variation.isJumpFrame(entity, frame);
        }

        @Override
        public boolean isDamageFrame(EntityNargacuga entity, int frame) {
            return NargacugaPounce.this.variation.isDamageFrame(entity, frame);
        }

        @Override
        public float getTurnRate(EntityNargacuga entity, int frame) {
            return NargacugaPounce.this.variation.getTurnRate(entity, frame);
        }
    }

    private static class NargaJumpAdapter
    extends AIGeneralJumpAttack.JumpAdapter<EntityNargacuga> {
        public NargaJumpAdapter(IAnimationProvider animProvider, ISelectionPredicate<EntityNargacuga> predicate, IWeightProvider<EntityNargacuga> weightProvider, IDamageProvider damageProvider) {
            super(animProvider, predicate, weightProvider, damageProvider, new IJumpParamterProvider.AttackTargetAdapter(1.0f), new AIGeneralJumpAttack.IJumpTimingProvider.JumpTimingAdapter(0, 0.0f));
        }

        public void setDynamicTimingAdapter(NargaJumpTiming timing) {
            this.jumpTiming = Objects.requireNonNull(timing);
        }

        public void setDynamicJumpParameterAdapter(NargaJumpParameter param) {
            this.jumpProvider = Objects.requireNonNull(param);
        }
    }
}

