/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.entity.nargacuga;

import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.actions.AIGeneralJumpAttack;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IDamageProvider;
import mhfc.net.common.ai.general.provider.IJumpParamterProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.monster.EntityNargacuga;
import net.minecraft.util.Vec3;

public class TailSlam
extends AIGeneralJumpAttack<EntityNargacuga> {
    private static final int MAX_ANGLE = 20;
    private static final float MAX_DISTANCE = 6.0f;
    private static final float WEIGHT = 13.0f;
    private static final int JUMP_FRAME = 19;
    private static final int JUMP_TIME = 12;
    private static final int ANIM_LENGTH = 100;
    private static final IAnimationProvider animation = new IAnimationProvider.AnimationAdapter("mhfc:models/Nargacuga/TailSlam.mcanm", 100);
    private static final ISelectionPredicate<EntityNargacuga> select = new ISelectionPredicate.SelectionAdapter<EntityNargacuga>(-20.0f, 20.0f, 0.0, 6.0);
    private static final IWeightProvider<EntityNargacuga> weight = new IWeightProvider.SimpleWeightAdapter<EntityNargacuga>(13.0f);
    private static final AIUtils.IDamageCalculator damageCalculator = AIUtils.defaultDamageCalc(50.0f, 100.0f, 80.0f);

    public TailSlam() {
        super(TailSlam.generateProvider());
    }

    private static AIGeneralJumpAttack.IJumpProvider<EntityNargacuga> generateProvider() {
        IDamageProvider.DamageAdapter damage = new IDamageProvider.DamageAdapter(damageCalculator);
        IJumpParamterProvider.ConstantAirTimeAdapter<EntityNargacuga> jumpParams = new IJumpParamterProvider.ConstantAirTimeAdapter<EntityNargacuga>(12.0f, new IJumpParamterProvider.ConstantAirTimeAdapter.ITargetResolver<EntityNargacuga>(){

            @Override
            public Vec3 getJumpTarget(EntityNargacuga entity) {
                return entity.func_70676_i(1.0f).func_72441_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
        });
        AIGeneralJumpAttack.IJumpTimingProvider.JumpTimingAdapter timing = new AIGeneralJumpAttack.IJumpTimingProvider.JumpTimingAdapter(19, 0.0f);
        AIGeneralJumpAttack.JumpAdapter<EntityNargacuga> adapter = new AIGeneralJumpAttack.JumpAdapter<EntityNargacuga>(animation, select, weight, damage, jumpParams, timing);
        return adapter;
    }

    @Override
    protected void finishExecution() {
        super.finishExecution();
        EntityNargacuga nargacuga = (EntityNargacuga)this.getEntity();
        nargacuga.field_70177_z = AIUtils.normalizeAngle(nargacuga.field_70177_z + 180.0f);
        nargacuga.func_70024_g(0.001, 0.0, 0.001);
    }
}

