/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.entity.tigrex;

import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.entity.monster.EntityTigrex;
import mhfc.net.common.entity.projectile.EntityTigrexBlock;
import mhfc.net.common.util.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class TigrexGroundHurl
extends ActionAdapter<EntityTigrex> {
    private static final float MIN_DIST = 3.0f;
    private static final int LAST_FRAME = 60;
    private static final int THROW_FRAME = 21;
    private static final int TURN_FRAMES = 14;
    private static final double SPLIT_MULTIPLIER = 0.125;
    private static final double THROW_HEIGHT = 0.35;
    private static final float TURN_RATE = 2.0f;
    private static final double MAX_ANGLE = 0.155;
    private boolean thrown;
    private int weightFactor;

    public TigrexGroundHurl() {
        this.setAnimation("mhfc:models/Tigrex/dirtthrow.mcanm");
        this.setLastFrame(60);
        this.weightFactor = 1;
    }

    @Override
    public float getWeight() {
        EntityTigrex tigrex = (EntityTigrex)this.getEntity();
        this.target = tigrex.func_70638_az();
        if (this.target == null) {
            return 0.0f;
        }
        Vec3 toTarget = WorldHelper.getVectorToTarget((Entity)tigrex, (Entity)this.target);
        if (toTarget.func_72432_b().func_72430_b(tigrex.func_70040_Z()) < 0.155) {
            return 0.0f;
        }
        double dist = toTarget.func_72433_c();
        int weight = this.weightFactor;
        if (this.weightFactor > 1) {
            --this.weightFactor;
        }
        return (float)(dist - 3.0) / (float)weight;
    }

    @Override
    public void beginExecution() {
        this.thrown = false;
        this.weightFactor *= 3;
    }

    @Override
    public void update() {
        if (this.thrown) {
            return;
        }
        EntityTigrex tigrex = (EntityTigrex)this.getEntity();
        if (this.getCurrentFrame() < 21) {
            if (this.getCurrentFrame() < 14) {
                tigrex.getTurnHelper().updateTurnSpeed(2.0f);
                tigrex.getTurnHelper().updateTargetPoint((Entity)tigrex.func_70638_az());
            }
            return;
        }
        Vec3 look = tigrex.func_70040_Z();
        Vec3 lookVec = tigrex.func_70040_Z();
        Vec3 rightSide = lookVec.func_72431_c(Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0));
        for (int i = 0; i < 3; ++i) {
            EntityTigrexBlock block = new EntityTigrexBlock(tigrex.field_70170_p, tigrex);
            double xCo = look.field_72450_a;
            double yCo = look.field_72448_b + 0.35;
            double zCo = look.field_72449_c;
            if (i == 0) {
                xCo += rightSide.field_72450_a * 0.125;
                zCo += rightSide.field_72449_c * 0.125;
            } else if (i == 2) {
                xCo -= rightSide.field_72450_a * 0.125;
                zCo -= rightSide.field_72449_c * 0.125;
            }
            block.func_70186_c(xCo, yCo, zCo, 1.0f, 0.5f);
            tigrex.field_70170_p.func_72838_d((Entity)block);
        }
        this.thrown = true;
    }
}

