/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.entity.tigrex;

import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.entity.monster.EntityTigrex;
import mhfc.net.common.util.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.Vec3;

public class TigrexRun
extends ActionAdapter<EntityTigrex> {
    private static final int runningStarts = 21;
    private static final int runningEnds = 60;
    private static final int attackEnd = 75;
    private static final float TURN_RATE_INITIAL = 10.5f;
    private static final float TURN_RATE_DURING_RUN = 0.15f;
    private static final float MAX_RUN_DISTANCE = 40.0f;
    private static final int MAX_RUN_FRAMES = 200;
    private static final double RUN_SPEED = 1.4;
    private static final double STOP_SPEED = 0.7;
    private static final AIUtils.IDamageCalculator damageCalc = AIUtils.defaultDamageCalc(28.0f, 62.0f, 1000.0f);
    private AttackPhase currentPhase;
    private PastEntityEnum hasPassed;
    private Vec3 runStartPoint;
    private int framesRunning;
    private int runCycles;

    public TigrexRun() {
        this.setAnimation("mhfc:models/Tigrex/run.mcanm");
    }

    @Override
    public float getWeight() {
        EntityTigrex tigrex = (EntityTigrex)this.getEntity();
        this.target = tigrex.func_70638_az();
        if (this.target == null) {
            return 0.0f;
        }
        Vec3 toTarget = WorldHelper.getVectorToTarget((Entity)tigrex, (Entity)this.target);
        double dist = toTarget.func_72433_c();
        return (float)Math.log(dist / 5.0 + 1.0);
    }

    @Override
    public void beginExecution() {
        EntityTigrex tig = (EntityTigrex)this.getEntity();
        this.target = tig.func_70638_az();
        tig.func_85030_a("mhfc:tigrex-charge", 1.0f, 1.0f);
        this.currentPhase = AttackPhase.START;
        this.hasPassed = PastEntityEnum.NOT_PASSED;
        this.runCycles = 0;
        this.framesRunning = 0;
        this.currentPhase.onPhaseStart(this);
        this.runStartPoint = Vec3.func_72443_a((double)tig.field_70165_t, (double)tig.field_70163_u, (double)tig.field_70161_v);
    }

    @Override
    public void update() {
        AttackPhase nextPhase;
        this.currentPhase.update(this);
        if (this.currentPhase.isDamaging) {
            AIUtils.damageCollidingEntities(this.getEntity(), damageCalc);
        }
        if (this.currentPhase != (nextPhase = this.currentPhase.next(this))) {
            nextPhase.onPhaseStart(this);
            this.currentPhase = nextPhase;
        }
    }

    @Override
    public boolean shouldContinue() {
        return this.currentPhase != AttackPhase.STOPPED;
    }

    @Override
    public void finishExecution() {
    }

    @Override
    public byte mutexBits() {
        return 1;
    }

    @Override
    public int setToNextFrame(int frame) {
        return super.setToNextFrame(this.currentPhase.nextFrame(this, frame));
    }

    private static enum AttackPhase {
        START(false){

            @Override
            public void onPhaseStart(TigrexRun attk) {
                EntityTigrex tigrex = (EntityTigrex)attk.getEntity();
                tigrex.field_70179_y = 0.0;
                tigrex.field_70181_x = 0.0;
                tigrex.field_70159_w = 0.0;
                tigrex.getTurnHelper().updateTurnSpeed(10.5f);
                ((EntityTigrex)attk.getEntity()).getTurnHelper().updateTargetPoint((Entity)attk.target);
            }

            @Override
            public void update(TigrexRun attk) {
                ((EntityTigrex)attk.getEntity()).getTurnHelper().forceUpdate();
            }

            @Override
            public AttackPhase next(TigrexRun attk) {
                if (attk.target == null) {
                    return STOPPED;
                }
                if (attk.getCurrentFrame() < 21) {
                    return START;
                }
                return RUNNING;
            }
        }
        ,
        RUNNING(true){

            @Override
            public void onPhaseStart(TigrexRun attk) {
                ((EntityTigrex)attk.getEntity()).getTurnHelper().updateTurnSpeed(0.15f);
                attk.framesRunning = 0;
            }

            @Override
            public void update(TigrexRun attk) {
                boolean ranLongEnough;
                EntityTigrex tigrex = (EntityTigrex)attk.getEntity();
                Vec3 tigPos = Vec3.func_72443_a((double)tigrex.field_70165_t, (double)tigrex.field_70163_u, (double)tigrex.field_70161_v);
                Vec3 vecToTarget = tigPos.func_72444_a(attk.target.func_70666_h(1.0f));
                tigrex.getTurnHelper().updateTargetPoint((Entity)attk.target);
                tigrex.moveForward(1.4, true);
                Vec3 look = tigrex.func_70040_Z();
                boolean tarBeh = vecToTarget.func_72432_b().func_72430_b(look) < 0.0;
                boolean bl = ranLongEnough = attk.runStartPoint.func_72444_a(tigPos).func_72433_c() > 40.0 || attk.framesRunning > 200;
                if ((tarBeh || ranLongEnough) && attk.hasPassed == PastEntityEnum.NOT_PASSED) {
                    attk.hasPassed = PastEntityEnum.PASSED;
                }
            }

            @Override
            public AttackPhase next(TigrexRun attk) {
                if (attk.hasPassed == PastEntityEnum.LOOP_FINISHED) {
                    return STOPPING;
                }
                return RUNNING;
            }

            @Override
            public int nextFrame(TigrexRun attk, int curr) {
                attk.framesRunning++;
                int looping = 39;
                if (attk.hasPassed == PastEntityEnum.PASSED && curr + 1 >= 60) {
                    attk.hasPassed = PastEntityEnum.LOOP_FINISHED;
                }
                return 21 + (curr + 1 - 21) % looping;
            }
        }
        ,
        STOPPING(true){

            @Override
            public void update(TigrexRun attk) {
                EntityTigrex e = (EntityTigrex)attk.getEntity();
                e.moveForward(0.7, false);
            }

            @Override
            public AttackPhase next(TigrexRun attk) {
                if (75 < attk.getCurrentFrame()) {
                    return STOPPED;
                }
                return STOPPING;
            }
        }
        ,
        STOPPED(false){

            @Override
            public void onPhaseStart(TigrexRun attk) {
                EntityCreature entity = attk.getEntity();
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
            }
        };

        public final boolean isDamaging;

        private AttackPhase(boolean isDamaging) {
            this.isDamaging = isDamaging;
        }

        public void onPhaseStart(TigrexRun attk) {
        }

        public void update(TigrexRun attk) {
        }

        public AttackPhase next(TigrexRun attk) {
            return this;
        }

        public int nextFrame(TigrexRun attk, int curr) {
            return ++curr;
        }
    }

    private static enum PastEntityEnum {
        NOT_PASSED,
        PASSED,
        LOOP_FINISHED,
        TURNING;

    }
}

