/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mhfc.net.common.entity.type.EntityWyvernHostile;
import mhfc.net.common.entity.type.EntityWyvernPeaceful;
import mhfc.net.common.util.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class AIUtils {
    public static final double RAD2DEG = 57.29577951308232;
    public static final double DEG2RAD = Math.PI / 180;

    public static void damageCollidingEntities(EntityLivingBase ai, final float damage) {
        AIUtils.damageCollidingEntities(ai, new IDamageCalculator(){

            @Override
            public float accept(Entity e) {
                return damage;
            }
        });
    }

    public static void damageCollidingEntities(EntityLivingBase ai, IDamageCalculator damageCalc) {
        List<Entity> collidingEntities = WorldHelper.collidingEntities((Entity)ai);
        for (Entity trgt : collidingEntities) {
            float damage = damageCalc.accept(trgt);
            trgt.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)ai), damage);
        }
    }

    public static IDamageCalculator defaultDamageCalc(float player, float wyvern, float rest) {
        return new DefDamageCalculator(player, wyvern, rest);
    }

    public static void stun(EntityLivingBase target) {
        target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 80, 10));
        target.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 80, 10));
    }

    public static float lookVecToYaw(Vec3 vec) {
        double pitch_rad = -Math.asin(vec.field_72448_b);
        double cos_pitch = -Math.cos(-pitch_rad);
        double yaw_rad = -Math.acos(vec.field_72449_c / cos_pitch);
        yaw_rad *= Math.signum(-vec.field_72450_a);
        return AIUtils.normalizeAngle((float)Math.toDegrees(yaw_rad += Math.PI));
    }

    public static float modifyYaw(Vec3 look, Vec3 target, float maxAbsoluteChange) {
        float yaw = AIUtils.lookVecToYaw(look);
        float tarYaw = AIUtils.lookVecToYaw(target);
        float diff = tarYaw - yaw;
        diff = (diff = AIUtils.normalizeAngle(diff)) < 0.0f ? (diff < -maxAbsoluteChange ? -maxAbsoluteChange : diff) : (diff > maxAbsoluteChange ? maxAbsoluteChange : diff);
        return AIUtils.normalizeAngle(yaw + diff);
    }

    public static float normalizeAngle(float yaw) {
        if ((yaw %= 360.0f) > 180.0f) {
            return yaw - 360.0f;
        }
        if (yaw < -180.0f) {
            return yaw + 360.0f;
        }
        return yaw;
    }

    public static boolean isInDistance(Vec3 direction, double minDistance, double maxDistance) {
        double distance = direction.func_72433_c();
        return distance >= minDistance && distance <= maxDistance;
    }

    public static float getViewingAngle(EntityLiving actor, Entity target) {
        Vec3 lookVector = actor.func_70040_Z();
        Vec3 targetVector = WorldHelper.getVectorToTarget((Entity)actor, target);
        float yaw = AIUtils.lookVecToYaw(lookVector);
        float tarYaw = AIUtils.lookVecToYaw(targetVector.func_72432_b());
        return AIUtils.normalizeAngle(tarYaw - yaw);
    }

    public static float getViewingAngle(EntityLiving actor, Vec3 point) {
        Vec3 lookVector = actor.func_70040_Z();
        Vec3 pos = actor.func_70666_h(1.0f);
        Vec3 targetVector = point.func_72444_a(pos);
        float yaw = AIUtils.lookVecToYaw(lookVector);
        float tarYaw = AIUtils.lookVecToYaw(targetVector);
        return AIUtils.normalizeAngle(tarYaw - yaw);
    }

    public static List<AxisAlignedBB> gatherOverlappingBounds(AxisAlignedBB bounds, Entity entity) {
        int minX = (int)Math.floor(bounds.field_72340_a);
        int maxX = (int)Math.ceil(bounds.field_72336_d);
        int minY = (int)Math.floor(bounds.field_72338_b);
        int maxY = (int)Math.ceil(bounds.field_72337_e);
        int minZ = (int)Math.floor(bounds.field_72339_c);
        int maxZ = (int)Math.ceil(bounds.field_72334_f);
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (int xC = minX; xC <= maxX; ++xC) {
            for (int yC = minY; yC <= maxY; ++yC) {
                for (int zC = minZ; zC <= maxZ; ++zC) {
                    entity.field_70170_p.func_147439_a(xC, yC, zC).func_149743_a(entity.field_70170_p, xC, yC, zC, bounds, list, entity);
                }
            }
        }
        return list;
    }

    public static class DamageCalculatorHelper {
        private IDamageCalculator calculator;
        private Type type = Type.NONE;

        public void setDamageCalculator(IDamageCalculator dmg) {
            this.calculator = dmg;
            this.type = this.calculator == null ? Type.NONE : Type.UNKNOWN;
        }

        public void setDefaultDamageCalculator(float player, float wyvern, float rest) {
            this.calculator = AIUtils.defaultDamageCalc(player, wyvern, rest);
            this.type = Type.DEFAULT;
        }

        public void setMemoryDamageCalculator(IDamageCalculator dmg) {
            this.calculator = new MemoryDamageCalculator(dmg);
            this.type = Type.MEMORY;
        }

        public void setMemoryDamageCalculator(float player, float wyvern, float rest) {
            this.calculator = new MemoryDamageCalculator(AIUtils.defaultDamageCalc(player, wyvern, rest));
            this.type = Type.MEMORY;
        }

        public void reset() {
            if (this.calculator == null) {
                return;
            }
            if (this.type == Type.MEMORY) {
                ((MemoryDamageCalculator)this.calculator).reset();
            }
            if (this.type == Type.UNKNOWN && this.calculator instanceof MemoryDamageCalculator) {
                ((MemoryDamageCalculator)this.calculator).reset();
            }
        }

        public IDamageCalculator getCalculator() {
            return this.calculator;
        }

        private static enum Type {
            MEMORY,
            DEFAULT,
            NONE,
            UNKNOWN;

        }
    }

    private static class DefDamageCalculator
    implements IDamageCalculator {
        private float player;
        private float wyvern;
        private float rest;

        public DefDamageCalculator(float player, float wyvern, float rest) {
            this.player = player;
            this.wyvern = wyvern;
            this.rest = rest;
        }

        @Override
        public float accept(Entity trgt) {
            if (trgt instanceof EntityPlayer) {
                return this.player;
            }
            if (trgt instanceof EntityWyvernHostile || trgt instanceof EntityWyvernPeaceful) {
                return this.wyvern;
            }
            return this.rest;
        }
    }

    public static class MemoryDamageCalculator
    extends DecisiveDamageCalculator {
        private final Set<Entity> damagedEntities = new HashSet<Entity>();
        private IDamageCalculator forward;

        public MemoryDamageCalculator(IDamageCalculator otherCalculator) {
            this.forward = Objects.requireNonNull(otherCalculator);
        }

        @Override
        public boolean shouldDamage(Entity e) {
            return !this.damagedEntities.contains(e);
        }

        @Override
        public float damage(Entity e) {
            this.damagedEntities.add(e);
            return this.forward.accept(e);
        }

        public void reset() {
            this.damagedEntities.clear();
        }
    }

    public static abstract class DecisiveDamageCalculator
    implements IDamageCalculator {
        public abstract boolean shouldDamage(Entity var1);

        public abstract float damage(Entity var1);

        @Override
        public float accept(Entity e) {
            if (this.shouldDamage(e)) {
                return this.damage(e);
            }
            return 0.0f;
        }
    }

    public static interface IDamageCalculator {
        public float accept(Entity var1);
    }
}

