/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general;

import mhfc.net.MHFCMain;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class TargetTurnHelper {
    private EntityMHFCBase<?> entity;
    private Vec3 targetPoint;
    private float maxTurnSpeed;
    private boolean isUpdating;

    public TargetTurnHelper(EntityMHFCBase<?> controlledEntity) {
        this.entity = controlledEntity;
    }

    public void updateTargetPoint(Vec3 vector) {
        if (vector == null) {
            return;
        }
        this.isUpdating = true;
        this.targetPoint = vector.func_72441_c(0.0, 0.0, 0.0);
    }

    public void updateTargetPoint(double x, double y, double z) {
        this.isUpdating = true;
        this.targetPoint = Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public void updateTargetPoint(Entity entity) {
        if (entity == null) {
            return;
        }
        this.isUpdating = true;
        this.targetPoint = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
    }

    public void updateTurnSpeed(float maxTurnSpeed) {
        this.isUpdating = true;
        this.maxTurnSpeed = maxTurnSpeed > 0.0f ? maxTurnSpeed : 0.0f;
    }

    public void forceUpdate() {
        this.isUpdating = true;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void onUpdateTurn() {
        if (!this.isUpdating) {
            return;
        }
        this.isUpdating = false;
        if (this.targetPoint == null || this.entity == null) {
            MHFCMain.logger.debug("No target despite updating");
            return;
        }
        Vec3 vecToTarget = Vec3.func_72443_a((double)this.entity.field_70165_t, (double)this.entity.field_70163_u, (double)this.entity.field_70161_v).func_72444_a(this.targetPoint);
        this.entity.field_70177_z = AIUtils.modifyYaw(this.entity.func_70040_Z(), vecToTarget.func_72432_b(), this.maxTurnSpeed);
        this.entity.func_70024_g(0.001, 0.0, 0.001);
    }
}

