/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general;

import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.entity.type.EntityMHFCBase;
import mhfc.net.common.util.world.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public class TurnAttack
extends ActionAdapter<EntityMHFCBase<?>> {
    private double minAngleCos;
    private double maxAngleCos;
    private float weight;
    private float turnRate;

    public TurnAttack(float minAngleDeg, float maxAngleDeg, float weight, float turnRate) {
        this.minAngleCos = Math.cos(Math.toRadians(minAngleDeg));
        this.maxAngleCos = Math.cos(Math.toRadians(maxAngleDeg));
        this.weight = weight;
        this.turnRate = turnRate;
    }

    protected boolean isValidTarget(Vec3 toTarget, Vec3 look) {
        double dot = (toTarget = toTarget.func_72432_b()).func_72430_b(look);
        return dot < this.minAngleCos && dot > this.maxAngleCos;
    }

    @Override
    public float getWeight() {
        Vec3 look;
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        EntityLivingBase target = entity.func_70638_az();
        if (target == null) {
            return 0.0f;
        }
        Vec3 vec = WorldHelper.getVectorToTarget((Entity)entity, (Entity)target);
        return this.isValidTarget(vec, look = entity.func_70040_Z()) ? this.weight : 0.0f;
    }

    @Override
    public void update() {
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        entity.getTurnHelper().updateTargetPoint((Entity)entity.func_70638_az());
        entity.getTurnHelper().updateTurnSpeed(this.turnRate);
    }
}

