/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general;

import java.util.List;
import java.util.Random;
import mhfc.net.MHFCMain;

public class WeightedPick {
    private static final ThreadLocal<Integer> size;
    private static final ThreadLocal<WeightedItem[]> itemcache;
    private static final ThreadLocal<double[]> weightcache;
    private static final Random rand;

    private static void rescale(int minSize) {
        WeightedPick.renewCache(minSize);
    }

    private static void renewCache(int newSize) {
        size.set(newSize);
        itemcache.set(new WeightedItem[size.get().intValue()]);
        weightcache.set(new double[size.get().intValue()]);
    }

    public static <T extends WeightedItem> T pickRandom(List<T> list) {
        if (list == null) {
            MHFCMain.logger.debug("List supplied to random pick null. Is some IAttackManager invalid?");
            return null;
        }
        WeightedItem[] items = itemcache.get();
        double[] weights = weightcache.get();
        int listsize = list.size();
        if (listsize > size.get()) {
            WeightedPick.rescale(listsize);
        }
        double sum = 0.0;
        int i = 0;
        for (WeightedItem item : list) {
            if (item.forceSelection()) {
                return (T)item;
            }
            double w = Math.max(0.0, (double)item.getWeight());
            if (w <= 0.0) continue;
            sum += w;
            items[i] = item;
            weights[i] = w;
            ++i;
        }
        int index = WeightedPick.pickRandomIndex(weights, i, sum);
        if (index < 0) {
            return null;
        }
        WeightedItem t = items[index];
        return (T)t;
    }

    private static int pickRandomIndex(double[] weights, int count, double sum) {
        if (count <= 0) {
            return -1;
        }
        double value = rand.nextDouble() * sum;
        sum = 0.0;
        while (count > 0) {
            if ((sum += weights[--count]) < value) continue;
            return count;
        }
        return -1;
    }

    static {
        rand = new Random();
        size = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 16;
            }
        };
        itemcache = new ThreadLocal<WeightedItem[]>(){

            @Override
            protected WeightedItem[] initialValue() {
                return new WeightedItem[((Integer)size.get()).intValue()];
            }
        };
        weightcache = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[((Integer)size.get()).intValue()];
            }
        };
    }

    public static interface WeightedItem {
        public float getWeight();

        public boolean forceSelection();
    }
}

