/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;

public abstract class AIAnimatedAction<EntityT extends EntityCreature>
extends ActionAdapter<EntityT> {
    private IAnimatedActionProvider<EntityT> provider;

    public AIAnimatedAction(IAnimatedActionProvider<EntityT> provider) {
        this.provider = Objects.requireNonNull(provider);
        this.setAnimation(provider.getAnimationLocation());
        this.setLastFrame(provider.getAnimationLength());
    }

    @Override
    public float getWeight() {
        Object entity = this.getEntity();
        this.target = entity.func_70638_az();
        if (this.provider.shouldSelectAttack(this, entity, (Entity)this.target)) {
            return this.provider.getWeight(entity, (Entity)this.target);
        }
        return 0.0f;
    }

    public static class AnimatedActionAdapter<EntityT extends EntityCreature>
    implements IAnimatedActionProvider<EntityT> {
        IAnimationProvider animationProvider;
        ISelectionPredicate<EntityT> selectionProvider;
        IWeightProvider<EntityT> weightProvider;

        public AnimatedActionAdapter(IAnimationProvider animationProvider, ISelectionPredicate<EntityT> selectionProvider, IWeightProvider<EntityT> weightProvider) {
            this.animationProvider = Objects.requireNonNull(animationProvider);
            this.selectionProvider = Objects.requireNonNull(selectionProvider);
            this.weightProvider = Objects.requireNonNull(weightProvider);
        }

        @Override
        public String getAnimationLocation() {
            return this.animationProvider.getAnimationLocation();
        }

        @Override
        public int getAnimationLength() {
            return this.animationProvider.getAnimationLength();
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.selectionProvider.shouldSelectAttack(attack, (EntityT)actor, target);
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weightProvider.getWeight(entity, target);
        }
    }

    public static interface IAnimatedActionProvider<EntityT extends EntityCreature>
    extends IAnimationProvider,
    ISelectionPredicate<EntityT>,
    IWeightProvider<EntityT> {
    }
}

