/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import mhfc.net.common.ai.ActionAdapter;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class AIGeneralIdle<EntityT extends EntityMHFCBase<? super EntityT>>
extends ActionAdapter<EntityT> {
    protected IAnimationProvider animation;
    protected IWeightProvider<EntityT> weight;
    protected ISelectionPredicate<EntityT> selectOnIdle;

    public AIGeneralIdle(IAnimationProvider animation, IWeightProvider<EntityT> weight) {
        this.animation = Objects.requireNonNull(animation);
        this.weight = Objects.requireNonNull(weight);
        this.selectOnIdle = new ISelectionPredicate.SelectIdleAdapter();
        this.setAnimation(animation.getAnimationLocation());
        this.setLastFrame(animation.getAnimationLength());
    }

    @Override
    public void beginAction() {
        ((EntityMHFCBase)this.getEntity()).func_70642_aH();
    }

    @Override
    public float getWeight() {
        EntityLivingBase target;
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        if (this.selectOnIdle.shouldSelectAttack(this, entity, (Entity)(target = entity.func_70638_az()))) {
            return this.weight.getWeight(entity, (Entity)target);
        }
        return 0.0f;
    }

    @Override
    protected void update() {
    }
}

