/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.actions.AIAnimatedAction;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IDamageProvider;
import mhfc.net.common.ai.general.provider.IJumpParamterProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class AIGeneralJumpAttack<EntityT extends EntityMHFCBase<? super EntityT>>
extends AIAnimatedAction<EntityT> {
    protected IJumpProvider<EntityT> provider;

    public AIGeneralJumpAttack(IJumpProvider<EntityT> provider) {
        super(provider);
        this.provider = provider;
        this.dmgHelper.setDamageCalculator(provider.getDamageCalculator());
        this.setAnimation(provider.getAnimationLocation());
        this.setLastFrame(provider.getAnimationLength());
    }

    @Override
    public float getWeight() {
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        this.target = entity.func_70638_az();
        if (this.provider.shouldSelectAttack(this, entity, (Entity)this.target)) {
            return this.provider.getWeight(entity, (Entity)this.target);
        }
        return 0.0f;
    }

    @Override
    public void beginExecution() {
        super.beginExecution();
        ((EntityMHFCBase)this.getEntity()).getTurnHelper().updateTurnSpeed(this.provider.getTurnRate((EntityMHFCBase)this.getEntity(), 0));
    }

    @Override
    public void update() {
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        Vec3 look = entity.func_70040_Z();
        Vec3 forward = Vec3.func_72443_a((double)look.field_72450_a, (double)0.0, (double)look.field_72448_b).func_72432_b();
        int frame = this.getCurrentFrame();
        float turnRate = this.provider.getTurnRate(entity, frame);
        if (turnRate > 0.0f) {
            entity.getTurnHelper().updateTurnSpeed(turnRate);
            entity.getTurnHelper().updateTargetPoint((Entity)((EntityMHFCBase)this.getEntity()).func_70638_az());
        }
        if (this.provider.isJumpFrame(entity, frame)) {
            float upVelocity = this.provider.getInitialUpVelocity(entity);
            float forwardVelocity = this.provider.getForwardVelocity(entity);
            upVelocity = Math.min(upVelocity, 20.0f);
            forwardVelocity = Math.min(forwardVelocity, 20.0f);
            entity.field_70159_w = forward.field_72450_a * (double)forwardVelocity;
            entity.field_70181_x = upVelocity;
            entity.field_70179_y = forward.field_72449_c * (double)forwardVelocity;
            entity.field_70160_al = true;
        }
        if (this.provider.isDamageFrame(entity, frame)) {
            AIUtils.damageCollidingEntities(this.getEntity(), this.dmgHelper.getCalculator());
        }
    }

    public static class JumpAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
    implements IJumpProvider<EntityT> {
        protected IAnimationProvider animationProvider;
        protected ISelectionPredicate<EntityT> predicate;
        protected IWeightProvider<EntityT> weightProvider;
        protected IDamageProvider damageProvider;
        protected IJumpParamterProvider<EntityT> jumpProvider;
        protected IJumpTimingProvider<EntityT> jumpTiming;

        public JumpAdapter(IAnimationProvider animProvider, ISelectionPredicate<EntityT> predicate, IWeightProvider<EntityT> weightProvider, IDamageProvider damageProvider, IJumpParamterProvider<EntityT> jumpProvider, IJumpTimingProvider<EntityT> jumpTiming) {
            this.animationProvider = Objects.requireNonNull(animProvider);
            this.predicate = Objects.requireNonNull(predicate);
            this.weightProvider = Objects.requireNonNull(weightProvider);
            this.damageProvider = Objects.requireNonNull(damageProvider);
            this.jumpProvider = Objects.requireNonNull(jumpProvider);
            this.jumpTiming = Objects.requireNonNull(jumpTiming);
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.predicate.shouldSelectAttack(attack, (EntityT)actor, target);
        }

        @Override
        public float getInitialUpVelocity(EntityT entity) {
            return this.jumpProvider.getInitialUpVelocity(entity);
        }

        @Override
        public float getForwardVelocity(EntityT entity) {
            return this.jumpProvider.getForwardVelocity(entity);
        }

        @Override
        public String getAnimationLocation() {
            return this.animationProvider.getAnimationLocation();
        }

        @Override
        public int getAnimationLength() {
            return this.animationProvider.getAnimationLength();
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weightProvider.getWeight(entity, target);
        }

        @Override
        public AIUtils.IDamageCalculator getDamageCalculator() {
            return this.damageProvider.getDamageCalculator();
        }

        @Override
        public boolean isJumpFrame(EntityT entity, int frame) {
            return this.jumpTiming.isJumpFrame(entity, frame);
        }

        @Override
        public boolean isDamageFrame(EntityT entity, int frame) {
            return this.jumpTiming.isDamageFrame(entity, frame);
        }

        @Override
        public float getTurnRate(EntityT entity, int frame) {
            return this.jumpTiming.getTurnRate(entity, frame);
        }
    }

    public static interface IJumpProvider<EntityT extends EntityMHFCBase<? super EntityT>>
    extends AIAnimatedAction.IAnimatedActionProvider<EntityT>,
    IDamageProvider,
    IJumpParamterProvider<EntityT>,
    IJumpTimingProvider<EntityT> {
    }

    public static interface IJumpTimingProvider<EntityT extends EntityMHFCBase<? super EntityT>> {
        public boolean isJumpFrame(EntityT var1, int var2);

        public boolean isDamageFrame(EntityT var1, int var2);

        public float getTurnRate(EntityT var1, int var2);

        public static class JumpTimingAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
        implements IJumpTimingProvider<EntityT> {
            private int jumpFrame;
            private float turnRate;

            public JumpTimingAdapter(int jumpFrame, float turnRate) {
                this.jumpFrame = jumpFrame;
                this.turnRate = turnRate;
            }

            @Override
            public boolean isJumpFrame(EntityT entity, int frame) {
                return frame == this.jumpFrame;
            }

            @Override
            public float getTurnRate(EntityT entity, int frame) {
                return this.turnRate;
            }

            @Override
            public boolean isDamageFrame(EntityT entity, int frame) {
                return frame > this.jumpFrame;
            }
        }
    }
}

