/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.actions.AIAnimatedAction;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IContinuationPredicate;
import mhfc.net.common.ai.general.provider.IMovementProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class AIGeneralMovement<EntityT extends EntityMHFCBase<? super EntityT>>
extends AIAnimatedAction<EntityT> {
    protected MovementActionProvider<EntityT> movementProvider;

    public AIGeneralMovement(MovementActionProvider<EntityT> movementActionProvider) {
        super(movementActionProvider);
        this.movementProvider = Objects.requireNonNull(movementActionProvider);
        this.setAnimation(this.movementProvider.getAnimationLocation());
        this.setLastFrame(movementActionProvider.getAnimationLength());
    }

    @Override
    protected void beginExecution() {
        super.beginExecution();
        this.movementProvider.initialize(this.getEntity());
    }

    @Override
    protected void update() {
        EntityMHFCBase actor = (EntityMHFCBase)this.getEntity();
        if (this.movementProvider.hasWaypointReached()) {
            this.movementProvider.onWaypointReached();
        } else {
            Vec3 checkPoint = this.movementProvider.getCurrentWaypoint();
            actor.getTurnHelper().updateTurnSpeed(this.movementProvider.getTurnRate());
            actor.getTurnHelper().updateTargetPoint(checkPoint);
            actor.moveForward(this.movementProvider.getMoveSpeed(), true);
        }
    }

    @Override
    public float getWeight() {
        if (this.movementProvider.shouldSelectAttack(this, this.getEntity(), (Entity)((EntityMHFCBase)this.getEntity()).func_70638_az())) {
            return this.movementProvider.getWeight(this.getEntity(), (Entity)((EntityMHFCBase)this.getEntity()).func_70638_az());
        }
        return 0.0f;
    }

    @Override
    public boolean shouldContinue() {
        return this.movementProvider.shouldContinueAction(this, this.getEntity());
    }

    public static class MovementActionAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
    implements MovementActionProvider<EntityT> {
        private IAnimationProvider animationProvider;
        private ISelectionPredicate<EntityT> selectionPredicate;
        private IContinuationPredicate<EntityT> continuationPredicate;
        private IWeightProvider<EntityT> weightProvider;
        private IMovementProvider<EntityT> movementProvider;

        public MovementActionAdapter(IAnimationProvider animationProvider, ISelectionPredicate<EntityT> selectionPredicate, IContinuationPredicate<EntityT> continuationPredicate, IWeightProvider<EntityT> weightProvider, IMovementProvider<EntityT> movementProvider) {
            this.animationProvider = Objects.requireNonNull(animationProvider);
            this.selectionPredicate = Objects.requireNonNull(selectionPredicate);
            this.continuationPredicate = Objects.requireNonNull(continuationPredicate);
            this.weightProvider = Objects.requireNonNull(weightProvider);
            this.movementProvider = Objects.requireNonNull(movementProvider);
        }

        @Override
        public String getAnimationLocation() {
            return this.animationProvider.getAnimationLocation();
        }

        @Override
        public int getAnimationLength() {
            return this.animationProvider.getAnimationLength();
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.selectionPredicate.shouldSelectAttack(attack, (EntityT)actor, target);
        }

        @Override
        public boolean shouldContinueAction(IExecutableAction<? super EntityT> attack, EntityT actor) {
            return this.continuationPredicate.shouldContinueAction(attack, (EntityT)actor);
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weightProvider.getWeight(entity, target);
        }

        @Override
        public float getTurnRate() {
            return this.movementProvider.getTurnRate();
        }

        @Override
        public float getMoveSpeed() {
            return this.movementProvider.getMoveSpeed();
        }

        @Override
        public void initialize(EntityT actor) {
            this.movementProvider.initialize(actor);
        }

        @Override
        public Vec3 getCurrentWaypoint() {
            return this.movementProvider.getCurrentWaypoint();
        }

        @Override
        public boolean hasWaypointReached() {
            return this.movementProvider.hasWaypointReached();
        }

        @Override
        public void onWaypointReached() {
            this.movementProvider.onWaypointReached();
        }
    }

    public static interface MovementActionProvider<EntityT extends EntityMHFCBase<? super EntityT>>
    extends AIAnimatedAction.IAnimatedActionProvider<EntityT>,
    IContinuationPredicate<EntityT>,
    IMovementProvider<EntityT> {
    }
}

