/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.actions.AIAnimatedAction;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AIGeneralRoar<EntityT extends EntityMHFCBase<? super EntityT>>
extends AIAnimatedAction<EntityT> {
    private Collection<EntityPlayer> affectedEntities;
    private IRoarProvider<EntityT> roarProvider;

    public AIGeneralRoar(IRoarProvider<EntityT> provider) {
        super(provider);
        this.setAnimation(provider.getAnimationLocation());
        this.setLastFrame(provider.getAnimationLength());
        this.affectedEntities = new HashSet<EntityPlayer>();
        this.roarProvider = provider;
    }

    @Override
    public void beginExecution() {
        this.affectedEntities.clear();
        ((EntityMHFCBase)this.getEntity()).func_85030_a(this.roarProvider.getRoarSoundLocation(), 1.0f, 1.0f);
    }

    @Override
    protected void update() {
        EntityMHFCBase roaringEntity = (EntityMHFCBase)this.getEntity();
        List list = roaringEntity.field_70170_p.func_72839_b((Entity)roaringEntity, roaringEntity.field_70121_D.func_72314_b(4.0, 3.0, 4.0));
        for (Entity affectedEntity : list) {
            if (this.affectedEntities.contains(affectedEntity) || !(affectedEntity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)affectedEntity;
            AIUtils.stun((EntityLivingBase)player);
            this.affectedEntities.add(player);
        }
    }

    public static class RoarAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
    implements IRoarProvider<EntityT> {
        private IAnimationProvider animationProvider;
        private ISelectionPredicate<EntityT> selectionProvider;
        private IWeightProvider<EntityT> weightProvider;
        private IRoarSoundProvider roarSoundProvider;

        public RoarAdapter(IAnimationProvider animation, ISelectionPredicate<EntityT> selection, IWeightProvider<EntityT> weight, IRoarSoundProvider roarSoundFile) {
            this.animationProvider = animation;
            this.selectionProvider = selection;
            this.weightProvider = weight;
            this.roarSoundProvider = roarSoundFile;
        }

        @Override
        public String getAnimationLocation() {
            return this.animationProvider.getAnimationLocation();
        }

        @Override
        public int getAnimationLength() {
            return this.animationProvider.getAnimationLength();
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.selectionProvider.shouldSelectAttack(attack, (EntityT)actor, target);
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weightProvider.getWeight(entity, target);
        }

        @Override
        public String getRoarSoundLocation() {
            return this.roarSoundProvider.getRoarSoundLocation();
        }
    }

    public static interface IRoarProvider<EntityT extends EntityMHFCBase<? super EntityT>>
    extends AIAnimatedAction.IAnimatedActionProvider<EntityT>,
    IRoarSoundProvider {
    }

    public static interface IRoarSoundProvider {
        public String getRoarSoundLocation();

        public static class RoarSoundAdapter
        implements IRoarSoundProvider {
            private String soundLocation;

            public RoarSoundAdapter(String soundLocation) {
                this.soundLocation = soundLocation;
            }

            @Override
            public String getRoarSoundLocation() {
                return this.soundLocation;
            }
        }
    }
}

