/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.actions.AIAnimatedAction;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IDamageProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.Entity;

public class AIGeneralTailWhip<EntityT extends EntityMHFCBase<? super EntityT>>
extends AIAnimatedAction<EntityT> {
    protected ISpinProvider<EntityT> provider;

    public AIGeneralTailWhip(ISpinProvider<EntityT> PROVIDER) {
        super(PROVIDER);
        this.provider = PROVIDER;
        this.dmgHelper.setDamageCalculator(this.provider.getDamageCalculator());
        this.setAnimation(this.provider.getAnimationLocation());
        this.setLastFrame(this.provider.getAnimationLength());
    }

    @Override
    public void beginExecution() {
        ((EntityMHFCBase)this.getEntity()).func_70661_as().func_75499_g();
    }

    @Override
    protected void update() {
        AIUtils.damageCollidingEntities(this.getEntity(), this.dmgHelper.getCalculator());
    }

    @Override
    public float getWeight() {
        EntityMHFCBase entity = (EntityMHFCBase)this.getEntity();
        this.target = entity.func_70638_az();
        if (this.provider.shouldSelectAttack(this, entity, (Entity)this.target)) {
            return this.provider.getWeight(entity, (Entity)this.target);
        }
        return 0.0f;
    }

    public static class TailWhipAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
    implements ISpinProvider<EntityT> {
        private IAnimationProvider animationProvider;
        private ISelectionPredicate<EntityT> predicate;
        private IWeightProvider<EntityT> weightProvider;
        private IDamageProvider damageProvider;

        public TailWhipAdapter(IAnimationProvider ANIMPROVIDER, IWeightProvider<EntityT> WEIGHTPROVIDER, IDamageProvider DAMAGEPROVIDER, ISelectionPredicate<EntityT> PREDICATE) {
            this.animationProvider = ANIMPROVIDER;
            this.damageProvider = DAMAGEPROVIDER;
            this.weightProvider = Objects.requireNonNull(WEIGHTPROVIDER);
            this.predicate = Objects.requireNonNull(PREDICATE);
        }

        @Override
        public String getAnimationLocation() {
            return this.animationProvider.getAnimationLocation();
        }

        @Override
        public int getAnimationLength() {
            return this.animationProvider.getAnimationLength();
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.predicate.shouldSelectAttack(attack, (EntityT)actor, target);
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weightProvider.getWeight(entity, target);
        }

        @Override
        public AIUtils.IDamageCalculator getDamageCalculator() {
            return this.damageProvider.getDamageCalculator();
        }
    }

    public static interface ISpinProvider<EntityT extends EntityMHFCBase<? super EntityT>>
    extends AIAnimatedAction.IAnimatedActionProvider<EntityT>,
    IDamageProvider {
    }
}

