/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.actions;

import java.util.Objects;
import java.util.Random;
import mhfc.net.common.ai.general.actions.AIGeneralMovement;
import mhfc.net.common.ai.general.provider.IAnimationProvider;
import mhfc.net.common.ai.general.provider.IContinuationPredicate;
import mhfc.net.common.ai.general.provider.IMoveParameterProvider;
import mhfc.net.common.ai.general.provider.IMovementProvider;
import mhfc.net.common.ai.general.provider.IPathProvider;
import mhfc.net.common.ai.general.provider.ISelectionPredicate;
import mhfc.net.common.ai.general.provider.IWeightProvider;
import mhfc.net.common.entity.type.EntityMHFCBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.Vec3;

public class AIGeneralWander<EntityT extends EntityMHFCBase<? super EntityT>>
extends AIGeneralMovement<EntityT> {
    public AIGeneralWander(IAnimationProvider animationProvider, IWeightProvider<EntityT> weightProvider, IMoveParameterProvider parameterProvider) {
        super(new WanderAdapter<EntityT>(animationProvider, weightProvider, parameterProvider));
    }

    public static class RandomWanderProvider<EntityT extends EntityLiving>
    implements IPathProvider<EntityT> {
        public static final int DEFAULT_WANDER_DISTANCE = 20;
        private Random random = new Random();
        private int wanderDistance;
        protected EntityT actor;
        protected Vec3 startingPosition;
        protected Vec3 waypoint;
        protected float acceptedDistance;

        public RandomWanderProvider() {
            this(20);
        }

        public RandomWanderProvider(int maxWanderDistance) {
            if (maxWanderDistance < 0) {
                throw new IllegalArgumentException("The wander distance must not be negative");
            }
            this.wanderDistance = maxWanderDistance;
        }

        @Override
        public void initialize(EntityT actor) {
            this.actor = (EntityLiving)Objects.requireNonNull(actor);
            this.startingPosition = actor.func_70666_h(1.0f);
            this.onWaypointReached();
        }

        @Override
        public Vec3 getCurrentWaypoint() {
            return this.waypoint;
        }

        @Override
        public boolean hasWaypointReached() {
            Vec3 position = this.actor.func_70666_h(1.0f);
            if (this.waypoint.func_72444_a(position).func_72433_c() < (double)this.acceptedDistance) {
                return true;
            }
            this.acceptedDistance += 0.01f * (float)this.wanderDistance;
            return false;
        }

        @Override
        public void onWaypointReached() {
            this.acceptedDistance = 0.5f;
            this.waypoint = this.generateNewRandomPoint();
        }

        private Vec3 generateNewRandomPoint() {
            int randomX = (int)(this.startingPosition.field_72450_a + (double)this.random.nextInt(this.wanderDistance));
            int randomZ = (int)(this.startingPosition.field_72449_c + (double)this.random.nextInt(this.wanderDistance));
            return Vec3.func_72443_a((double)randomX, (double)this.startingPosition.field_72448_b, (double)randomZ);
        }
    }

    public static class WanderAdapter<EntityT extends EntityMHFCBase<? super EntityT>>
    extends AIGeneralMovement.MovementActionAdapter<EntityT> {
        private static <EntityT extends EntityMHFCBase<? super EntityT>> ISelectionPredicate<EntityT> SelectionPredicate() {
            return new ISelectionPredicate.SelectIdleAdapter();
        }

        private static <EntityT extends EntityMHFCBase<? super EntityT>> IContinuationPredicate<EntityT> ContinuationPredicate() {
            return new IContinuationPredicate.HasNoTargetAdapter();
        }

        private static <EntityT extends EntityMHFCBase<? super EntityT>> IMovementProvider<EntityT> MovementProvider(IMoveParameterProvider provider) {
            RandomWanderProvider pathProvider = new RandomWanderProvider();
            return new IMovementProvider.TurnThenMoveAdapter(pathProvider, provider, 5.0f);
        }

        public WanderAdapter(IAnimationProvider animationProvider, IWeightProvider<EntityT> weightProvider, IMoveParameterProvider movementProvider) {
            super(animationProvider, WanderAdapter.SelectionPredicate(), WanderAdapter.ContinuationPredicate(), weightProvider, WanderAdapter.MovementProvider(movementProvider));
        }
    }
}

