/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.provider;

import java.security.InvalidParameterException;
import java.util.Objects;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public interface IJumpParamterProvider<EntityT extends EntityLivingBase> {
    public float getInitialUpVelocity(EntityT var1);

    public float getForwardVelocity(EntityT var1);

    public static class AttackTargetAdapter<EntityT extends EntityLiving>
    extends ConstantAirTimeAdapter<EntityT> {
        public AttackTargetAdapter(float jumpTimeInTicks) {
            super(jumpTimeInTicks, new ConstantAirTimeAdapter.ITargetResolver<EntityT>(){

                @Override
                public Vec3 getJumpTarget(EntityLiving entity) {
                    EntityLivingBase attackTarget = entity.func_70638_az();
                    Vec3 target = attackTarget != null ? attackTarget.func_70666_h(1.0f) : entity.func_70666_h(1.0f);
                    return target;
                }
            });
        }
    }

    public static class AttackPointAdapter<EntityT extends EntityLiving>
    extends ConstantAirTimeAdapter<EntityT> {
        public AttackPointAdapter(float jumpTimeInTicks, Vec3 targetPoint) {
            super(jumpTimeInTicks, new ConstPointResolver(targetPoint));
        }

        private static class ConstPointResolver<EntityT extends EntityLiving>
        implements ConstantAirTimeAdapter.ITargetResolver<EntityT> {
            private Vec3 targetPoint;

            public ConstPointResolver(Vec3 target) {
                this.targetPoint = target;
            }

            @Override
            public Vec3 getJumpTarget(EntityT entity) {
                return this.targetPoint;
            }
        }
    }

    public static class ConstantAirTimeAdapter<EntityT extends EntityLiving>
    implements IJumpParamterProvider<EntityT> {
        public static final float GRAVITATIONAL_C_LIVING = 0.08f;
        protected float airTime;
        private ITargetResolver<EntityT> targetResolver;

        public ConstantAirTimeAdapter(float jumpAirTimeInTicks, ITargetResolver<EntityT> targetResolver) {
            this.airTime = jumpAirTimeInTicks;
            this.targetResolver = Objects.requireNonNull(targetResolver);
            if (this.airTime <= 0.0f) {
                throw new InvalidParameterException("Jump time must be bigger than zero");
            }
        }

        @Override
        public float getInitialUpVelocity(EntityT entity) {
            Vec3 target = Objects.requireNonNull(this.targetResolver.getJumpTarget(entity));
            float velocity = (float)(target.field_72448_b - ((EntityLiving)entity).field_70163_u) / this.airTime + 0.08f * this.airTime / 2.0f;
            return velocity;
        }

        @Override
        public float getForwardVelocity(EntityT entity) {
            Vec3 target = Objects.requireNonNull(this.targetResolver.getJumpTarget(entity));
            float distance = (float)entity.func_70666_h(1.0f).func_72438_d(target);
            float velocity = distance / this.airTime * 3.0f * (this.airTime * 0.02f) / (1.0f - (float)Math.pow(0.98, this.airTime));
            return velocity;
        }

        public static interface ITargetResolver<EntityT extends EntityLiving> {
            public Vec3 getJumpTarget(EntityT var1);
        }
    }
}

