/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.provider;

import java.util.Objects;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.provider.IMoveParameterProvider;
import mhfc.net.common.ai.general.provider.IPathProvider;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.Vec3;

public interface IMovementProvider<EntityT extends EntityLiving>
extends IMoveParameterProvider,
IPathProvider<EntityT> {

    public static class TurnThenMoveAdapter<EntityT extends EntityLiving>
    implements IMovementProvider<EntityT> {
        private IPathProvider<EntityT> underlyingPathProvider;
        private IMoveParameterProvider moveParameterProvider;
        private EntityT actor;
        private float maxAngle;

        public TurnThenMoveAdapter(IPathProvider<EntityT> underlyingPathProvider, IMoveParameterProvider moveParameterProvider, float allowedAngle) {
            this.underlyingPathProvider = Objects.requireNonNull(underlyingPathProvider);
            this.moveParameterProvider = Objects.requireNonNull(moveParameterProvider);
            this.maxAngle = allowedAngle;
        }

        @Override
        public void initialize(EntityT actor) {
            this.underlyingPathProvider.initialize(actor);
            this.actor = actor;
        }

        @Override
        public Vec3 getCurrentWaypoint() {
            return this.underlyingPathProvider.getCurrentWaypoint();
        }

        @Override
        public boolean hasWaypointReached() {
            return this.underlyingPathProvider.hasWaypointReached();
        }

        @Override
        public void onWaypointReached() {
            this.underlyingPathProvider.onWaypointReached();
        }

        @Override
        public float getTurnRate() {
            return this.moveParameterProvider.getTurnRate();
        }

        @Override
        public float getMoveSpeed() {
            float angle = AIUtils.getViewingAngle(this.actor, this.getCurrentWaypoint());
            if (Math.abs(angle) <= this.maxAngle) {
                return this.moveParameterProvider.getMoveSpeed();
            }
            return 0.1f;
        }
    }
}

