/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.Vec3;

public interface IPathProvider<EntityT extends EntityLiving> {
    public void initialize(EntityT var1);

    public Vec3 getCurrentWaypoint();

    public boolean hasWaypointReached();

    public void onWaypointReached();

    public static class PathCircleAdapter<EntityT extends EntityLiving>
    extends PathListAdapter<EntityT> {
        public PathCircleAdapter(List<Vec3> path, double allowedDistance) {
            super(path, allowedDistance);
        }

        public PathCircleAdapter(List<Vec3> path) {
            super(path);
        }

        public PathCircleAdapter(Vec3[] nodes, double allowedDistance) {
            super(nodes, allowedDistance);
        }

        public PathCircleAdapter(Vec3[] nodes) {
            super(nodes);
        }

        @Override
        public void onWaypointReached() {
            super.onWaypointReached();
            if (this.currentIndex == this.path.size()) {
                this.currentIndex = 0;
            }
        }
    }

    public static class PathListAdapter<EntityT extends EntityLiving>
    implements IPathProvider<EntityT> {
        public static final double DEFAULT_MAX_DISTANCE = 0.25;
        private EntityT actor;
        protected List<Vec3> path;
        protected int currentIndex;
        protected double maxDistance;

        public PathListAdapter(List<Vec3> path, double allowedDistance) {
            Objects.requireNonNull(path);
            this.path = new ArrayList<Vec3>(path.size());
            this.path.addAll(path);
            this.currentIndex = 0;
            this.maxDistance = allowedDistance;
        }

        public PathListAdapter(List<Vec3> path) {
            this(path, 0.25);
        }

        public PathListAdapter(Vec3[] nodes, double allowedDistance) {
            Objects.requireNonNull(nodes);
            this.path = Arrays.asList(nodes);
            this.currentIndex = 0;
            this.maxDistance = allowedDistance;
        }

        public PathListAdapter(Vec3[] nodes) {
            this(nodes, 0.25);
        }

        @Override
        public void initialize(EntityT actor) {
            this.actor = (EntityLiving)Objects.requireNonNull(actor);
            this.currentIndex = 0;
        }

        @Override
        public Vec3 getCurrentWaypoint() {
            if (this.currentIndex < this.path.size()) {
                return this.path.get(this.currentIndex);
            }
            return null;
        }

        @Override
        public boolean hasWaypointReached() {
            Vec3 position = this.actor.func_70666_h(0.0f);
            return position.func_72444_a(this.getCurrentWaypoint()).func_72433_c() < this.maxDistance;
        }

        @Override
        public void onWaypointReached() {
            ++this.currentIndex;
        }
    }
}

