/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.provider;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Objects;
import mhfc.net.common.ai.IActionRecorder;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.eventhandler.ai.ActionSelectionEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;

public interface ISelectionPredicate<EntityT extends EntityLiving> {
    public boolean shouldSelectAttack(IExecutableAction<? super EntityT> var1, EntityT var2, Entity var3);

    public static class SpecificLastActionAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private IExecutableAction<? super EntityT> actionToTrack;

        public SpecificLastActionAdapter(IExecutableAction<? super EntityT> actionToTrack) {
            this.actionToTrack = actionToTrack;
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return ((IActionRecorder)actor).getLastAction() == this.actionToTrack;
        }
    }

    public static class AllOfAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private ISelectionPredicate<EntityT>[] group;

        public AllOfAdapter(ISelectionPredicate<EntityT>[] toFulfil) {
            this.group = Objects.requireNonNull(toFulfil);
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            boolean all = true;
            for (ISelectionPredicate<? super EntityT> iSelectionPredicate : this.group) {
                all &= iSelectionPredicate.shouldSelectAttack(attack, (EntityT)actor, target);
            }
            return all;
        }
    }

    public static class SelectAlways<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return true;
        }
    }

    public static class SelectIdleAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return target == null;
        }
    }

    public static class AngleAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private float minAngle;
        private float maxAngle;

        public AngleAdapter(float minAngle, float maxAngle) {
            this.minAngle = minAngle;
            this.maxAngle = maxAngle;
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            if (target == null) {
                return false;
            }
            float angle = AIUtils.getViewingAngle(actor, target);
            return angle >= this.minAngle && angle <= this.maxAngle;
        }
    }

    public static class DistanceAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private double minDistance;
        private double maxDistance;

        public DistanceAdapter(double minDistance, double maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            if (target == null) {
                return false;
            }
            double distance = actor.func_70032_d(target);
            return distance >= this.minDistance && distance <= this.maxDistance;
        }
    }

    public static class CooldownAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private int cooldown;
        private int cooldownRemaining;
        private IExecutableAction<? super EntityT> attack;
        ISelectionPredicate<? super EntityT> originalPredicate;

        public CooldownAdapter(IExecutableAction<? super EntityT> attack, int cooldown, ISelectionPredicate<EntityT> originalPredicate) {
            this.attack = Objects.requireNonNull(attack);
            this.originalPredicate = Objects.requireNonNull(originalPredicate);
            this.cooldown = cooldown;
            this.cooldownRemaining = 0;
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            if (this.cooldownRemaining > 0) {
                --this.cooldownRemaining;
            }
            return this.cooldownRemaining == 0;
        }

        @SubscribeEvent
        public void onSelectionSuccess(ActionSelectionEvent ase) {
            if (ase.chosenAction == this.attack) {
                this.cooldownRemaining = this.cooldown;
            }
        }
    }

    public static class SelectionAdapter<EntityT extends EntityLiving>
    implements ISelectionPredicate<EntityT> {
        private DistanceAdapter<EntityT> distanceAdapter;
        private AngleAdapter<EntityT> angleAdapter;

        public SelectionAdapter(float minAngle, float maxAngle, double minDistance, double maxDistance) {
            this.distanceAdapter = new DistanceAdapter(minDistance, maxDistance);
            this.angleAdapter = new AngleAdapter(minAngle, maxAngle);
        }

        @Override
        public boolean shouldSelectAttack(IExecutableAction<? super EntityT> attack, EntityT actor, Entity target) {
            return this.distanceAdapter.shouldSelectAttack(attack, (EntityT)actor, target) && this.angleAdapter.shouldSelectAttack(attack, (EntityT)actor, target);
        }
    }
}

