/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.ai.general.provider;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;

public interface IWeightProvider<EntityT extends EntityLiving> {
    public float getWeight(EntityT var1, Entity var2);

    public static class RandomWeightAdapter<EntityT extends EntityLiving>
    implements IWeightProvider<EntityT> {
        private static final Random rng = new Random(System.nanoTime());
        private float max;

        public RandomWeightAdapter(float maximum) {
            this.max = maximum;
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return rng.nextFloat() * this.max;
        }
    }

    public static class SimpleWeightAdapter<EntityT extends EntityLiving>
    implements IWeightProvider<EntityT> {
        private float weight;

        public SimpleWeightAdapter(float weight) {
            this.weight = weight;
        }

        @Override
        public float getWeight(EntityT entity, Entity target) {
            return this.weight;
        }
    }
}

