/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.block;

import java.util.List;
import java.util.Random;
import mhfc.net.MHFCMain;
import mhfc.net.common.tile.TileQuestBoard;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuestBoard
extends BlockContainer {
    public static int upMask = 8;
    public static int offsetMask = 4;
    public static int rotationMask = 3;

    public BlockQuestBoard() {
        super(Material.field_151575_d);
        this.func_149663_c("questboard");
        this.func_149711_c(3.0f);
        this.func_149647_a(MHFCMain.mhfctabs);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149727_a(World var1, int var2, int var3, int var4, EntityPlayer player, int var6, float var7, float var8, float var9) {
        if (!player.func_70093_af()) {
            player.openGui((Object)MHFCMain.instance, 3, var1, var2, var3, var4);
            return true;
        }
        return false;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("mhfc:benchtable");
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileQuestBoard();
    }

    public Item func_149650_a(int p_149650_1_, Random random, int p_149650_3_) {
        switch (random.nextInt(3)) {
            case 0: {
                return Items.field_151034_e;
            }
            case 1: {
                return Items.field_151104_aV;
            }
            case 2: {
                return Items.field_151082_bd;
            }
        }
        return null;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (side > 1) {
            if (side == 2) {
                return 6;
            }
            if (side == 3) {
                return 4;
            }
            if (side == 4) {
                return 5;
            }
            if (side == 5) {
                return 7;
            }
        } else {
            meta = 0;
            if (side == 0) {
                meta += upMask;
            }
            return meta;
        }
        return side;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (!world.field_72995_K) {
            Vec3 vecPos = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
            float f1 = MathHelper.func_76134_b((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
            Vec3 look = Vec3.func_72443_a((double)(f2 * f3 * 160.0f), (double)(f4 * 160.0f), (double)(f1 * f3 * 160.0f));
            Vec3 blockVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
            Vec3 lookAim = look.func_72441_c(vecPos.field_72450_a, vecPos.field_72448_b, vecPos.field_72449_c);
            MovingObjectPosition movPos = world.func_147447_a(vecPos, lookAim, false, false, true);
            int side = this.getOppositeSide(blockVec.func_72444_a(movPos.field_72307_f), look);
            int meta = world.func_72805_g(x, y, z);
            double hitX = look.field_72450_a;
            double hitZ = look.field_72449_c;
            if (side > 1) {
                if (side == 2) {
                    meta = 6;
                }
                if (side == 3) {
                    meta = 4;
                }
                if (side == 4) {
                    meta = 5;
                }
                if (side == 5) {
                    meta = 7;
                }
            } else {
                float cosAng = (float)(hitZ / Math.sqrt(hitX * hitX + hitZ * hitZ));
                float angle = (float)(Math.acos(cosAng) / Math.PI * 180.0);
                if (hitX > 0.0) {
                    angle = 360.0f - angle;
                }
                angle += 45.0f;
                int metaData = (int)((angle %= 360.0f) / 90.0f);
                metaData &= rotationMask;
                if (side == 0) {
                    metaData += upMask;
                }
                meta = metaData;
            }
            world.func_72921_c(x, y, z, meta, 3);
        }
        super.func_149689_a(world, x, y, z, entity, stack);
    }

    private int getOppositeSide(Vec3 hitVector, Vec3 lookVector) {
        int side;
        double dX = Math.signum(lookVector.field_72450_a);
        double dY = lookVector.field_72448_b / lookVector.field_72450_a * dX;
        double dZ = lookVector.field_72449_c / lookVector.field_72450_a * dX;
        double targetX = lookVector.field_72450_a > 0.0 ? 1.0 : 0.0;
        double targetY = lookVector.field_72448_b > 0.0 ? 1.0 : 0.0;
        double targetZ = lookVector.field_72449_c > 0.0 ? 1.0 : 0.0;
        double tX = (targetX - hitVector.field_72450_a) / dX;
        double tY = (targetY - hitVector.field_72448_b) / dY;
        double tZ = (targetZ - hitVector.field_72449_c) / dZ;
        double t = tX;
        if (!(tX > 0.0 && tY >= 0.0 && tZ >= 0.0)) {
            MHFCMain.logger.debug("Noooo");
        }
        int n = side = lookVector.field_72450_a > 0.0 ? 4 : 5;
        if (!Double.isNaN(tY) && tY < t) {
            side = lookVector.field_72448_b > 0.0 ? 0 : 1;
            t = tY;
        }
        if (!Double.isNaN(tZ) && tZ < t) {
            side = lookVector.field_72449_c > 0.0 ? 2 : 3;
        }
        return side;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        float maxZ;
        float minZ;
        float maxX;
        float minX;
        float minY;
        int meta = blockAccess.func_72805_g(x, y, z);
        boolean boxUpFlag = (meta & upMask) == upMask | (meta & offsetMask) == offsetMask;
        float maxY = !boxUpFlag ? 0.7f : 1.0f;
        float f = minY = !boxUpFlag ? 0.0f : 0.3f;
        if ((meta & 1) == 0) {
            minX = 0.0f;
            maxX = 1.0f;
        } else if ((meta & offsetMask) == offsetMask) {
            if ((meta & rotationMask) == 1) {
                minX = 0.75f;
                maxX = 1.0f;
            } else {
                minX = 0.0f;
                maxX = 0.25f;
            }
        } else {
            minX = 0.375f;
            maxX = 0.625f;
        }
        if ((meta & 1) == 1) {
            minZ = 0.0f;
            maxZ = 1.0f;
        } else if ((meta & offsetMask) == offsetMask) {
            if ((meta & rotationMask) == 2) {
                minZ = 0.75f;
                maxZ = 1.0f;
            } else {
                minZ = 0.0f;
                maxZ = 0.25f;
            }
        } else {
            minZ = 0.375f;
            maxZ = 0.625f;
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void func_149743_a(World p_149743_1_, int p_149743_2_, int p_149743_3_, int p_149743_4_, AxisAlignedBB p_149743_5_, List p_149743_6_, Entity p_149743_7_) {
        this.func_149719_a((IBlockAccess)p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
    }
}

