/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.configuration;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class MHFCConfig {
    public final boolean allCanPickup;
    public final boolean spawnTigrex;
    public final boolean spawnKirin;
    public final boolean setupComplexGraphics = false;
    private Map<String, EnableSetting> enableSettings = new LinkedHashMap<String, EnableSetting>();
    private Map<String, ReloadTimeSetting> reloadTimeSettings = new LinkedHashMap<String, ReloadTimeSetting>();
    private Configuration config;

    public MHFCConfig(FMLPreInitializationEvent e) {
        this.config = new Configuration(e.getSuggestedConfigurationFile());
        this.spawnTigrex = this.config.get("MHFC Mobs", "Summon Tigrex", true).getBoolean(true);
        this.spawnKirin = this.config.get("MHFC Mobs", "Summon Kirin", true).getBoolean(true);
        this.allCanPickup = this.config.get("settings", "pickup-all", true, "Another work-in-progress soon.").getBoolean(true);
        this.config.save();
    }

    public void init() {
        for (EnableSetting es : this.enableSettings.values()) {
            es.enabled = this.config.get("enable", es.settingName, es.enabled).getBoolean(es.enabled);
        }
        for (ReloadTimeSetting rs : this.reloadTimeSettings.values()) {
            rs.reloadTime = this.config.get("reloadtime", rs.settingName, rs.reloadTime).getInt(rs.reloadTime);
        }
    }

    public void addEnableSetting(String weapon) {
        this.enableSettings.put(weapon, new EnableSetting(weapon));
    }

    public void addReloadTimeSetting(String weapon, int defaulttime) {
        this.reloadTimeSettings.put(weapon, new ReloadTimeSetting(weapon, defaulttime));
    }

    public boolean isEnabled(String weapon) {
        EnableSetting es = this.enableSettings.get(weapon);
        return es == null || es.enabled;
    }

    public int getReloadTime(String weapon) {
        ReloadTimeSetting rs = this.reloadTimeSettings.get(weapon);
        return rs == null ? 0 : rs.reloadTime;
    }

    private static class EnableSetting
    extends Setting {
        boolean enabled = true;

        EnableSetting(String name) {
            super(name + ".enabled");
        }
    }

    private static class ReloadTimeSetting
    extends Setting {
        int reloadTime;

        ReloadTimeSetting(String name, int time) {
            super(name + ".reloadtime");
            this.reloadTime = time;
        }
    }

    private static abstract class Setting {
        final String settingName;

        Setting(String name) {
            this.settingName = name;
        }
    }
}

