/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core;

import cpw.mods.fml.common.FMLLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mhfc.net.MHFCMain;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class MHFCMobList {
    private static final Logger logger;
    private static Map<String, Class<? extends Entity>> stringToClassMapping;
    private static Map<Class<? extends Entity>, String> classToStringMapping;
    private static Map<Integer, Class<? extends Entity>> IDtoClassMapping;
    private static Map<Class<? extends Entity>, Integer> classToIDMapping;
    private static Map<String, Integer> stringToIDMapping;
    private static Map<Integer, MHFCEggInfo> entityEggs;

    public static void addMapping(Class<? extends Entity> clazz, String name, int id) {
        stringToClassMapping.put(name, clazz);
        classToStringMapping.put(clazz, name);
        IDtoClassMapping.put(id, clazz);
        classToIDMapping.put(clazz, id);
        stringToIDMapping.put(name, id);
    }

    public static void addMapping(Class<? extends Entity> clazz, String name, int id, int foregroundcolor, int backgroundcolor) {
        MHFCMobList.addMapping(clazz, name, id);
        entityEggs.put(id, new MHFCEggInfo(id, foregroundcolor, backgroundcolor));
    }

    private static Entity createEntityByClass(Class<? extends Entity> oclass, World world) {
        if (oclass == null) {
            return null;
        }
        Entity entity = null;
        try {
            entity = oclass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityByName(String name, World world) {
        Entity entity = MHFCMobList.createEntityByClass(MHFCMobList.getClassFromName(name), world);
        if (entity == null) {
            logger.warn("Skipping Entity with id " + name);
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound nbtTag, World world) {
        Class<? extends Entity> oclass = stringToClassMapping.get(nbtTag.func_74779_i("id"));
        Entity entity = MHFCMobList.createEntityByClass(oclass, world);
        if (entity == null) {
            logger.warn("Skipping Entity with id " + nbtTag.func_74779_i("id"));
            return null;
        }
        try {
            entity.func_70020_e(nbtTag);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{nbtTag.func_74779_i("id"), oclass.getName()});
            entity = null;
        }
        return entity;
    }

    public static Entity createEntityByID(int par0, World par1World) {
        Entity entity = MHFCMobList.createEntityByClass(MHFCMobList.getClassFromID(par0), par1World);
        if (entity == null) {
            logger.warn("Skipping Entity with id " + par0);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        Class<?> oclass = entity.getClass();
        return classToIDMapping.containsKey(oclass) ? classToIDMapping.get(oclass) : -1;
    }

    public static String getEntityString(Entity entity) {
        return classToStringMapping.get(entity.getClass());
    }

    public static Class<? extends Entity> getClassFromName(String name) {
        return stringToClassMapping.get(name);
    }

    public static Class<? extends Entity> getClassFromID(int id) {
        return IDtoClassMapping.get(id);
    }

    public static String getStringFromID(int id) {
        Class<? extends Entity> oclass = MHFCMobList.getClassFromID(id);
        return oclass != null ? classToStringMapping.get(oclass) : null;
    }

    public static Set<String> nameset() {
        return Collections.unmodifiableSet(stringToIDMapping.keySet());
    }

    public static Map<Integer, MHFCEggInfo> registeredEggs() {
        return Collections.unmodifiableMap(entityEggs);
    }

    public static StatBase getKills(MHFCEggInfo eggInfo) {
        String s = MHFCMobList.getStringFromID(eggInfo.spawnedID);
        return s == null ? null : new StatBase("stat.killEntity." + s, (IChatComponent)new ChatComponentTranslation("stat.entityKill", new Object[]{new ChatComponentTranslation("entity." + s + ".name", new Object[0])})).func_75971_g();
    }

    public static StatBase getKilledBy(MHFCEggInfo eggInfo) {
        String s = MHFCMobList.getStringFromID(eggInfo.spawnedID);
        return s == null ? null : new StatBase("stat.entityKilledBy." + s, (IChatComponent)new ChatComponentTranslation("stat.entityKilledBy", new Object[]{new ChatComponentTranslation("entity." + s + ".name", new Object[0])})).func_75971_g();
    }

    static {
        stringToClassMapping = new HashMap<String, Class<? extends Entity>>();
        classToStringMapping = new HashMap<Class<? extends Entity>, String>();
        IDtoClassMapping = new HashMap<Integer, Class<? extends Entity>>();
        classToIDMapping = new HashMap<Class<? extends Entity>, Integer>();
        stringToIDMapping = new HashMap<String, Integer>();
        entityEggs = new LinkedHashMap<Integer, MHFCEggInfo>();
        MHFCMain.checkPreInitialized();
        logger = MHFCMain.logger;
    }

    public static class MHFCEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;
        public final StatBase field_151512_d;
        public final StatBase field_151513_e;

        public MHFCEggInfo(int par1, int par2, int par3) {
            this.spawnedID = par1;
            this.primaryColor = par2;
            this.secondaryColor = par3;
            this.field_151512_d = MHFCMobList.getKills(this);
            this.field_151513_e = MHFCMobList.getKilledBy(this);
        }
    }
}

