/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.builders;

import java.util.ArrayList;
import java.util.List;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BuilderEquipmentRecipe {
    private EquipmentRecipe.RecipeType type;
    private ItemStack recipeProduct;
    List<ItemStack> recipeIngredients = new ArrayList<ItemStack>();
    private int requiredHeat;
    private int duration;

    public BuilderEquipmentRecipe() {
        this.reset();
    }

    public BuilderEquipmentRecipe setType(EquipmentRecipe.RecipeType type) {
        this.type = type;
        return this;
    }

    public BuilderEquipmentRecipe setProduct(Item item, int amount, int subtype) {
        return this.setProduct(BuilderEquipmentRecipe.createItemStack(item, amount, subtype));
    }

    public BuilderEquipmentRecipe setProduct(ItemStack stack) {
        this.recipeProduct = stack;
        return this;
    }

    public BuilderEquipmentRecipe addIngredient(Item item, int amount, int subtype) {
        return this.addIngredient(BuilderEquipmentRecipe.createItemStack(item, amount, subtype));
    }

    public BuilderEquipmentRecipe addIngredient(ItemStack stack) {
        this.recipeIngredients.add(stack);
        return this;
    }

    public BuilderEquipmentRecipe setRequiredHeat(int heat) {
        this.requiredHeat = heat;
        return this;
    }

    public BuilderEquipmentRecipe setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public BuilderEquipmentRecipe reset() {
        this.recipeIngredients.clear();
        this.type = null;
        this.recipeProduct = null;
        this.requiredHeat = 0;
        this.duration = 0;
        return this;
    }

    public EquipmentRecipe build() {
        EquipmentRecipe recipe = this.type == null ? new EquipmentRecipe(this.recipeProduct, this.recipeIngredients, this.requiredHeat, this.duration) : new EquipmentRecipe(this.type, this.recipeProduct, this.recipeIngredients, this.requiredHeat, this.duration);
        this.reset();
        return recipe;
    }

    public static ItemStack createItemStack(Item item, int stackSize, int subID) {
        ItemStack s = new ItemStack(item, stackSize);
        s.func_77964_b(subID);
        return s;
    }
}

