/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.data;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;

public class EquipmentRecipeRegistryData {
    private Map<EquipmentRecipe.RecipeType, Set<EquipmentRecipe>> mapOfRecipeSets = new HashMap<EquipmentRecipe.RecipeType, Set<EquipmentRecipe>>();
    private Map<EquipmentRecipe.RecipeType, List<EquipmentRecipe>> mapOfListOfRecipes = new HashMap<EquipmentRecipe.RecipeType, List<EquipmentRecipe>>();

    public EquipmentRecipeRegistryData() {
        EquipmentRecipe.RecipeType[] types = EquipmentRecipe.RecipeType.values();
        for (int i = 0; i < types.length; ++i) {
            this.mapOfRecipeSets.put(types[i], new LinkedHashSet());
            this.mapOfListOfRecipes.put(types[i], new LinkedList());
        }
    }

    private boolean register(EquipmentRecipe recipe, EquipmentRecipe.RecipeType type) {
        boolean inserted = this.mapOfRecipeSets.get((Object)type).add(recipe);
        if (inserted) {
            this.mapOfListOfRecipes.get((Object)type).add(recipe);
        }
        return inserted;
    }

    public void register(EquipmentRecipe recipe) {
        Objects.requireNonNull(recipe);
        this.register(recipe, recipe.getRecipeType());
    }

    public Set<EquipmentRecipe> getRecipesForType(EquipmentRecipe.RecipeType type) {
        return this.mapOfRecipeSets.get((Object)type);
    }

    public int getIDFor(EquipmentRecipe recipe) {
        if (recipe == null) {
            return -1;
        }
        List<EquipmentRecipe> list = this.mapOfListOfRecipes.get((Object)recipe.getRecipeType());
        return list.indexOf(recipe);
    }

    public EquipmentRecipe getRecipeFor(int id, EquipmentRecipe.RecipeType type) {
        List<EquipmentRecipe> list = this.mapOfListOfRecipes.get((Object)type);
        if (list == null) {
            return null;
        }
        if (id < 0 || id >= list.size()) {
            return null;
        }
        return list.get(id);
    }
}

