/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.registry;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import mhfc.net.MHFCMain;
import mhfc.net.common.core.MHFCMobList;
import mhfc.net.common.entity.monster.EntityBarroth;
import mhfc.net.common.entity.monster.EntityDeviljho;
import mhfc.net.common.entity.monster.EntityGreatJaggi;
import mhfc.net.common.entity.monster.EntityTigrex;
import mhfc.net.common.entity.projectile.EntityBullet;
import mhfc.net.common.entity.projectile.EntityFlashBomb;
import mhfc.net.common.entity.projectile.EntityRathalosFireball;
import mhfc.net.common.entity.projectile.EntityTigrexBlock;
import mhfc.net.common.entity.quests.EntityQuestGiver;
import net.minecraft.entity.Entity;

public class MHFCEntityRegistry {
    private static int entityID = 0;
    private static final MHFCMain mod;
    private static final List<Class<? extends Entity>> registeredMobs;
    private static final List<Class<? extends Entity>> registeredProjectiles;
    public static final int tigrexID;
    public static final int greatjaggiID;
    public static int deviljhoID;
    public static int nargacugaID;
    public static final int barrothID;
    public static final int questGiverID;
    public static final int tigrexBlockID;
    public static final int rathalosFireballID;
    public static final int bulletID;
    public static final int flashbombID;

    public static void init() {
    }

    private static int getMobID(Class<? extends Entity> clazz, String name) {
        if (MHFCEntityRegistry.isRegistered(clazz)) {
            return -1;
        }
        int monsterID = MHFCEntityRegistry.getMobID();
        EntityRegistry.registerModEntity(clazz, (String)name, (int)monsterID, (Object)mod, (int)64, (int)1, (boolean)true);
        registeredMobs.add(clazz);
        MHFCMobList.addMapping(clazz, name, monsterID);
        return monsterID;
    }

    private static int getMobID(Class<? extends Entity> clazz, String name, int foreground, int background) {
        if (MHFCEntityRegistry.isRegistered(clazz)) {
            return -1;
        }
        int monsterID = MHFCEntityRegistry.getMobID();
        EntityRegistry.registerModEntity(clazz, (String)name, (int)monsterID, (Object)mod, (int)64, (int)1, (boolean)true);
        registeredMobs.add(clazz);
        MHFCMobList.addMapping(clazz, name, monsterID, foreground, background);
        return monsterID;
    }

    private static int getProjectileID(Class<? extends Entity> clazz, String name) {
        if (MHFCEntityRegistry.isRegistered(clazz)) {
            return -1;
        }
        int projectileID = MHFCEntityRegistry.getProjID();
        EntityRegistry.registerModEntity(clazz, (String)name, (int)projectileID, (Object)mod, (int)64, (int)10, (boolean)true);
        registeredProjectiles.add(clazz);
        return projectileID;
    }

    private static int getProjectileID(Class<? extends Entity> clazz, String name, int customTrackingRange) {
        if (MHFCEntityRegistry.isRegistered(clazz)) {
            return -1;
        }
        int projectileID = MHFCEntityRegistry.getProjID();
        EntityRegistry.registerModEntity(clazz, (String)name, (int)projectileID, (Object)mod, (int)customTrackingRange, (int)10, (boolean)true);
        registeredProjectiles.add(clazz);
        return projectileID;
    }

    private static int getMobID() {
        return entityID++;
    }

    private static int getProjID() {
        return entityID++;
    }

    private static boolean isRegistered(Class<?> clazz) {
        return registeredMobs.contains(clazz) || registeredProjectiles.contains(clazz);
    }

    static {
        MHFCMain.checkPreInitialized();
        mod = MHFCMain.instance;
        registeredMobs = new ArrayList<Class<? extends Entity>>();
        registeredProjectiles = new ArrayList<Class<? extends Entity>>();
        tigrexID = MHFCEntityRegistry.getMobID(EntityTigrex.class, "tigrex", -773405, 270547279);
        greatjaggiID = MHFCEntityRegistry.getMobID(EntityGreatJaggi.class, "greatjaggi", -15622255, 0xFF929FF);
        deviljhoID = MHFCEntityRegistry.getMobID(EntityDeviljho.class, "deviljho", 117408255, -15607760);
        barrothID = MHFCEntityRegistry.getMobID(EntityBarroth.class, "barroth", 0x6FFFFFF, 6636321);
        questGiverID = MHFCEntityRegistry.getMobID(EntityQuestGiver.class, "questGiver");
        tigrexBlockID = MHFCEntityRegistry.getProjectileID(EntityTigrexBlock.class, "TigrexBlock");
        bulletID = MHFCEntityRegistry.getProjectileID(EntityBullet.class, "Bullet");
        rathalosFireballID = MHFCEntityRegistry.getProjectileID(EntityRathalosFireball.class, "Fireball");
        flashbombID = MHFCEntityRegistry.getProjectileID(EntityFlashBomb.class, "Flashbomb", 200);
    }
}

