/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.registry;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.util.Set;
import mhfc.net.MHFCMain;
import mhfc.net.common.core.data.EquipmentRecipeRegistryData;
import mhfc.net.common.core.directors.DirectorEquipmentRecipes;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;
import mhfc.net.common.network.message.bench.MessageBeginCrafting;
import mhfc.net.common.network.message.bench.MessageBenchRefreshRequest;
import mhfc.net.common.network.message.bench.MessageCancelRecipe;
import mhfc.net.common.network.message.bench.MessageCraftingUpdate;
import mhfc.net.common.network.message.bench.MessageSetRecipe;
import mhfc.net.common.network.packet.MessageTileLocation;
import mhfc.net.common.tile.TileHunterBench;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;

public class MHFCEquipementRecipeRegistry {
    private static EquipmentRecipeRegistryData dataObject = new EquipmentRecipeRegistryData();
    private static DirectorEquipmentRecipes recipeDirector = new DirectorEquipmentRecipes();

    private static TileHunterBench getHunterBench(MessageTileLocation message) {
        return MHFCEquipementRecipeRegistry.getHunterBench(message, true);
    }

    public static TileHunterBench getHunterBench(MessageTileLocation message, boolean server) {
        Object world = null;
        if (server) {
            int id = message.getDimensionID();
            MinecraftServer mcserver = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (mcserver == null) {
                return null;
            }
            world = mcserver.func_71218_a(id);
        } else {
            WorldClient clientW = FMLClientHandler.instance().getWorldClient();
            world = clientW.field_73011_w.field_76574_g == message.getDimensionID() ? clientW : null;
        }
        if (world != null) {
            TileEntity bench = world.func_147438_o(message.getX(), message.getY(), message.getZ());
            if (!(bench instanceof TileHunterBench)) {
                MHFCMain.logger.error("No tile entity for a block hunter bench found");
                return null;
            }
            return (TileHunterBench)bench;
        }
        return null;
    }

    public static Set<EquipmentRecipe> getRecipesForType(EquipmentRecipe.RecipeType type) {
        return dataObject.getRecipesForType(type);
    }

    public static int getIDFor(EquipmentRecipe recipe) {
        return dataObject.getIDFor(recipe);
    }

    public static EquipmentRecipe getRecipeFor(int recipeID, EquipmentRecipe.RecipeType recipeType) {
        return dataObject.getRecipeFor(recipeID, recipeType);
    }

    static {
        recipeDirector.construct(dataObject);
    }

    public static class CraftingUpdateHandler
    implements IMessageHandler<MessageCraftingUpdate, IMessage> {
        public IMessage onMessage(MessageCraftingUpdate message, MessageContext ctx) {
            TileHunterBench b = MHFCEquipementRecipeRegistry.getHunterBench(message, false);
            if (b != null) {
                b.readCustomUpdate(message.getNBTTag());
            }
            return null;
        }
    }

    public static class BeginCraftingHandler
    implements IMessageHandler<MessageBeginCrafting, MessageCraftingUpdate> {
        public MessageCraftingUpdate onMessage(MessageBeginCrafting message, MessageContext ctx) {
            TileHunterBench b = MHFCEquipementRecipeRegistry.getHunterBench(message);
            b.beginCrafting();
            return new MessageCraftingUpdate(b);
        }
    }

    public static class CancelRecipeHandler
    implements IMessageHandler<MessageCancelRecipe, MessageCraftingUpdate> {
        public MessageCraftingUpdate onMessage(MessageCancelRecipe message, MessageContext ctx) {
            TileHunterBench b = MHFCEquipementRecipeRegistry.getHunterBench(message);
            b.cancelRecipe();
            return new MessageCraftingUpdate(b);
        }
    }

    public static class SetRecipeHandler
    implements IMessageHandler<MessageSetRecipe, MessageCraftingUpdate> {
        public MessageCraftingUpdate onMessage(MessageSetRecipe message, MessageContext ctx) {
            TileHunterBench b = MHFCEquipementRecipeRegistry.getHunterBench(message);
            EquipmentRecipe.RecipeType recipeType = message.getRecipeType();
            EquipmentRecipe rec = MHFCEquipementRecipeRegistry.getRecipeFor(message.getRecipeID(), recipeType);
            b.changeRecipe(rec);
            return new MessageCraftingUpdate(b);
        }
    }

    public static class BenchRefreshHandler
    implements IMessageHandler<MessageBenchRefreshRequest, MessageCraftingUpdate> {
        public MessageCraftingUpdate onMessage(MessageBenchRefreshRequest message, MessageContext ctx) {
            TileHunterBench b = MHFCEquipementRecipeRegistry.getHunterBench(message);
            return new MessageCraftingUpdate(b);
        }
    }
}

