/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import mhfc.net.MHFCMain;
import mhfc.net.common.eventhandler.MHFCInteractionHandler;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageQuestScreenInit;
import mhfc.net.common.quests.QuestVisualInformation;
import mhfc.net.common.quests.api.GoalDescription;
import mhfc.net.common.quests.api.GoalReference;
import mhfc.net.common.quests.api.IGoalFactory;
import mhfc.net.common.quests.api.QuestDescription;
import mhfc.net.common.quests.api.QuestFactory;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class MHFCQuestBuildRegistry {
    public static final ParameterizedType typeOfMapGoal = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, GoalDescription.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final ParameterizedType typeOfMapQuest = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, QuestDescription.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final ParameterizedType typeOfGroupMap = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, new ParameterizedType(){

                @Override
                public Type getRawType() {
                    return List.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{String.class};
                }
            }};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static ParameterizedType typeOfGroupList = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final HashMap<String, QuestDescription> questDescriptions = new HashMap();
    public static final Map<String, List<String>> groupMapping = new HashMap<String, List<String>>();
    public static final List<String> groupIDs = new ArrayList<String>();
    public static final HashMap<String, GoalDescription> goalDescriptions = new HashMap();
    static final Gson gsonInstance = new GsonBuilder().registerTypeAdapter(GoalDescription.class, (Object)new GoalSerializer()).registerTypeAdapter(QuestDescription.class, (Object)new QuestSerializer()).registerTypeAdapter(GoalReference.class, (Object)new GoalReference.GoalRefSerializer()).create();
    public static final String GOAL_CHAIN_TYPE = "chain";
    public static final String GOAL_FORK_TYPE = "fork";
    public static final String GOAL_DEATH_RESTRICTION_TYPE = "death";
    public static final String GOAL_HUNTING_TYPE = "hunting";
    public static final String GOAL_TIME_TYPE = "time";
    public static final String QUEST_TYPE_HUNTING = "mhfc.quests.type.hunting";
    public static final String QUEST_TYPE_GATHERING = "mhfc.quests.type.gathering";
    public static final String QUEST_TYPE_EPIC_HUNTING = "mhfc.quests.type.epichunting";
    public static final String QUEST_TYPE_KILLING = "mhfc.quests.type.killing";

    private static String getJsonObjectStringFieldValueOrDefault(JsonObject p_151219_0_, String p_151219_1_, String p_151219_2_) {
        return p_151219_0_.has(p_151219_1_) ? JsonUtils.func_151206_a((JsonElement)p_151219_0_.get(p_151219_1_), (String)p_151219_1_) : p_151219_2_;
    }

    private static int getJsonObjectIntegerFieldValueOrDefault(JsonObject p_151208_0_, String p_151208_1_, int p_151208_2_) {
        return p_151208_0_.has(p_151208_1_) ? JsonUtils.func_151215_f((JsonElement)p_151208_0_.get(p_151208_1_), (String)p_151208_1_) : p_151208_2_;
    }

    public static void init() {
        MHFCQuestBuildRegistry.loadQuests();
        FMLCommonHandler.instance().bus().register((Object)new MHFCQuestBuildRegistry());
    }

    @SubscribeEvent
    void onModReload(MHFCInteractionHandler.MHFCInteractionModReloadEvent event) {
        questDescriptions.clear();
        goalDescriptions.clear();
        groupIDs.clear();
        groupMapping.clear();
        MHFCQuestBuildRegistry.loadQuests();
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestScreenInit(groupMapping, groupIDs), player);
        }
    }

    public static void loadQuests() {
        MHFCQuestBuildRegistry.generateQuests(new ResourceLocation("mhfc:quests/quests.json"));
        MHFCQuestBuildRegistry.generateGoals(new ResourceLocation("mhfc:quests/goals.json"));
        MHFCQuestBuildRegistry.generateGroupMapping(new ResourceLocation("mhfc:quests/groups.json"));
        MHFCMain.logger.info("Quest loaded");
    }

    static void generateGoals(ResourceLocation location) {
        if (location != null) {
            String pathToRes = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            try (InputStream input = MHFCQuestBuildRegistry.class.getResourceAsStream(pathToRes);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                Map map = (Map)gsonInstance.fromJson((Reader)reader, (Type)typeOfMapGoal);
                for (String qualifier : map.keySet()) {
                    goalDescriptions.put(qualifier, (GoalDescription)map.get(qualifier));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static void generateGroupMapping(ResourceLocation location) {
        if (location != null) {
            String pathToRes = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            try (InputStream input = MHFCQuestBuildRegistry.class.getResourceAsStream(pathToRes);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                JsonReader jSonRead = new JsonReader((Reader)reader);
                jSonRead.setLenient(true);
                List list = (List)gsonInstance.fromJson(jSonRead, (Type)typeOfGroupList);
                Map map = (Map)gsonInstance.fromJson(jSonRead, (Type)typeOfGroupMap);
                if (!map.keySet().containsAll(list) || !list.containsAll(map.keySet())) {
                    throw new JsonParseException("[MHFC] Group identifier list and mapping keys have to contain the same elements");
                }
                groupIDs.addAll(list);
                groupMapping.putAll(map);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static void generateQuests(ResourceLocation location) {
        if (location != null) {
            String pathToRes = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            try (InputStream input = MHFCQuestBuildRegistry.class.getResourceAsStream(pathToRes);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                Map map = (Map)gsonInstance.fromJson((Reader)reader, (Type)typeOfMapQuest);
                for (String qualifier : map.keySet()) {
                    if (qualifier.equals("")) {
                        throw new InputMismatchException("[MHFC] Quest identifier can not be an empty string");
                    }
                    questDescriptions.put(qualifier, (QuestDescription)map.get(qualifier));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static QuestDescription getQuestDescription(String id) {
        QuestDescription qd = questDescriptions.get(id);
        return qd;
    }

    public static GoalDescription getGoalDescription(String id) {
        GoalDescription qd = goalDescriptions.get(id);
        return qd;
    }

    static class GoalSerializer
    implements JsonDeserializer<GoalDescription> {
        GoalSerializer() {
        }

        public GoalDescription deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json == null || !json.isJsonObject()) {
                throw new JsonParseException("Expected a json object for a goal, got a primitive or null");
            }
            JsonObject jsonAsObject = json.getAsJsonObject();
            if (!jsonAsObject.has("type")) {
                throw new JsonParseException("Goal has no type");
            }
            String type = JsonUtils.func_151200_h((JsonObject)jsonAsObject, (String)"type");
            IGoalFactory gFactory = QuestFactory.getGoalFactory(type);
            return gFactory.buildGoalDescription(jsonAsObject, context);
        }
    }

    static class QuestSerializer
    implements JsonDeserializer<QuestDescription> {
        QuestSerializer() {
        }

        public QuestDescription deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonAsObject = JsonUtils.func_151210_l((JsonElement)json, (String)"quest");
            if (!jsonAsObject.has("name")) {
                throw new JsonParseException("Every Quest needs a name");
            }
            if (!jsonAsObject.has("goal")) {
                throw new JsonParseException("Every Quest needs a goal");
            }
            if (!jsonAsObject.has("reward")) {
                throw new JsonParseException("Every Quest needs a reward");
            }
            if (!jsonAsObject.has("fee")) {
                throw new JsonParseException("Every Quest needs a fee");
            }
            if (!jsonAsObject.has("areaID")) {
                throw new JsonParseException("Every Quest needs an area");
            }
            String goal = null;
            GoalDescription goalDesc = null;
            if (jsonAsObject.get("goal").isJsonPrimitive()) {
                goal = JsonUtils.func_151206_a((JsonElement)jsonAsObject, (String)"goal");
            } else {
                goalDesc = (GoalDescription)context.deserialize(jsonAsObject.get("goal"), GoalDescription.class);
            }
            String name = JsonUtils.func_151200_h((JsonObject)jsonAsObject, (String)"name");
            int timeLimitInS = MHFCQuestBuildRegistry.getJsonObjectIntegerFieldValueOrDefault(jsonAsObject, "timeLimit", 3000);
            String description = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "description", "A new monster threatens the town so go out and kill it soon.");
            String client = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "client", "Hunter Guild");
            String aims = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "fails", "Kill all big monsters!");
            String fails = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "fails", "Died three times or time has run out!");
            String areaId = JsonUtils.func_151200_h((JsonObject)jsonAsObject, (String)"areaID");
            String typeString = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "type", MHFCQuestBuildRegistry.GOAL_HUNTING_TYPE);
            QuestVisualInformation.QuestType type = QuestVisualInformation.QuestType.Hunting;
            switch (typeString) {
                default: {
                    System.out.println("[MHFC] Type string was not recognized, allowed are hunting, epichunting, gathering and killing\n Falling back to hunting.");
                }
                case "hunting": {
                    type = QuestVisualInformation.QuestType.Hunting;
                    break;
                }
                case "epichunting": {
                    type = QuestVisualInformation.QuestType.EpicHunting;
                    break;
                }
                case "gathering": {
                    type = QuestVisualInformation.QuestType.Gathering;
                    break;
                }
                case "killing": {
                    type = QuestVisualInformation.QuestType.Killing;
                }
            }
            int reward = JsonUtils.func_151203_m((JsonObject)jsonAsObject, (String)"reward");
            int fee = JsonUtils.func_151203_m((JsonObject)jsonAsObject, (String)"fee");
            int maxPartySize = MHFCQuestBuildRegistry.getJsonObjectIntegerFieldValueOrDefault(jsonAsObject, "maxPartySize", 4);
            String rewardAsString = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "rewardAsString", Integer.toString(reward) + "z");
            String feeAsString = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "feeAsString", Integer.toString(fee) + "z");
            String timeLimitAsString = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "timeLimitAsString", Integer.toString(timeLimitInS / 60) + " min" + (timeLimitInS % 60 == 0 ? "" : " " + Integer.toString(timeLimitInS % 60) + " s"));
            String maxPartySizeAsString = MHFCQuestBuildRegistry.getJsonObjectStringFieldValueOrDefault(jsonAsObject, "maxPartySizeAsString", Integer.toString(maxPartySize) + " hunters");
            if (goal != null) {
                return new QuestDescription(goal, name, type, reward, fee, maxPartySize, areaId, description, client, aims, fails, rewardAsString, feeAsString, timeLimitAsString, maxPartySizeAsString);
            }
            return new QuestDescription(goalDesc, name, type, reward, fee, maxPartySize, areaId, description, client, aims, fails, rewardAsString, feeAsString, timeLimitAsString, maxPartySizeAsString);
        }
    }
}

