/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.core.registry;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mhfc.net.MHFCMain;
import mhfc.net.common.core.registry.MHFCQuestBuildRegistry;
import mhfc.net.common.eventhandler.MHFCInteractionHandler;
import mhfc.net.common.network.PacketPipeline;
import mhfc.net.common.network.packet.MessageMHFCInteraction;
import mhfc.net.common.network.packet.MessageQuestRunningSubscription;
import mhfc.net.common.network.packet.MessageQuestScreenInit;
import mhfc.net.common.network.packet.MessageQuestVisual;
import mhfc.net.common.network.packet.MessageRequestQuestVisual;
import mhfc.net.common.quests.GeneralQuest;
import mhfc.net.common.quests.QuestVisualInformation;
import mhfc.net.common.quests.api.QuestDescription;
import mhfc.net.common.quests.api.QuestFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MHFCQuestRegistry {
    protected static HashMap<EntityPlayer, GeneralQuest> playerQuest = new HashMap();
    protected static List<GeneralQuest> questsRunning = new ArrayList<GeneralQuest>();
    protected static Map<String, GeneralQuest> runningQuestFromStringMap = new HashMap<String, GeneralQuest>();
    protected static Map<GeneralQuest, String> runningQuestToStringMap = new HashMap<GeneralQuest, String>();

    @SubscribeEvent
    void onPlayerInteraction(MHFCInteractionHandler.MHFCInteractionEvent event) {
        EntityPlayerMP player = event.player;
        MessageMHFCInteraction message = event.message;
        switch (event.interaction) {
            case NEW_QUEST: {
                GeneralQuest quest = MHFCQuestRegistry.getQuestForPlayer((EntityPlayer)player);
                if (quest == null) {
                    String registerFor = message.getOptions()[0] + "@" + player.getDisplayName();
                    GeneralQuest newQuest = QuestFactory.constructQuest(MHFCQuestBuildRegistry.getQuestDescription(message.getOptions()[0]), (EntityPlayer)player, registerFor);
                    if (newQuest != null) break;
                    player.func_145747_a((IChatComponent)new ChatComponentText("Quest not found"));
                    return;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("You already are on quest " + MHFCQuestRegistry.getIdentifierForQuest(quest)));
                String id = MHFCQuestRegistry.getIdentifierForQuest(quest);
                PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestVisual(id, quest.getRunningInformation()), player);
                break;
            }
            case ACCEPT_QUEST: {
                GeneralQuest quest = MHFCQuestRegistry.getRunningQuest(message.getOptions()[0]);
                if (quest == null) break;
                quest.addPlayer((EntityPlayer)player);
                break;
            }
            case START_QUEST: {
                GeneralQuest quest = MHFCQuestRegistry.getQuestForPlayer((EntityPlayer)player);
                if (quest == null) break;
                quest.voteStart(player);
                break;
            }
            case END_QUEST: {
                GeneralQuest quest = MHFCQuestRegistry.getQuestForPlayer((EntityPlayer)player);
                if (quest != null) {
                    quest.voteEnd(player);
                    break;
                }
                PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestVisual("", null), player);
                break;
            }
            case FORFEIT_QUEST: {
                GeneralQuest quest = MHFCQuestRegistry.getQuestForPlayer((EntityPlayer)player);
                if (quest != null) {
                    quest.removePlayer((EntityPlayer)player);
                    break;
                }
                PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestVisual("", null), player);
                break;
            }
            case MOD_RELOAD: {
                for (GeneralQuest genQ : questsRunning) {
                    RunningSubscriptionHandler.sendToAll(new MessageQuestVisual(MHFCQuestRegistry.getIdentifierForQuest(genQ), genQ.getRunningInformation()));
                }
                break;
            }
        }
    }

    public static void init() {
        FMLCommonHandler.instance().bus().register((Object)new MHFCQuestRegistry());
        FMLCommonHandler.instance().bus().register((Object)new PlayerConnectionHandler());
    }

    public static GeneralQuest getRunningQuest(String string) {
        return runningQuestFromStringMap.get(string);
    }

    public static GeneralQuest getQuestForPlayer(EntityPlayer player) {
        return playerQuest.get(player);
    }

    public static List<GeneralQuest> getRunningQuests() {
        return questsRunning;
    }

    public static String getIdentifierForQuest(GeneralQuest quest) {
        return runningQuestToStringMap.get(quest);
    }

    public static void setQuestForPlayer(EntityPlayer player, GeneralQuest generalQuest) {
        if (generalQuest == null) {
            playerQuest.remove(player);
        } else {
            playerQuest.put(player, generalQuest);
        }
    }

    public static void regRunningQuest(GeneralQuest generalQuest, String identifier) {
        questsRunning.add(generalQuest);
        MHFCMain.logger.debug(questsRunning.size() + " quests are running at the moment.");
        runningQuestFromStringMap.put(identifier, generalQuest);
        runningQuestToStringMap.put(generalQuest, identifier);
        MessageQuestVisual message = new MessageQuestVisual(identifier, generalQuest.getRunningInformation());
        message.setTypeID(2);
        RunningSubscriptionHandler.sendToAll(message);
    }

    public static boolean deregRunningQuest(GeneralQuest generalQuest) {
        boolean wasRunning = questsRunning.remove(generalQuest);
        String key = runningQuestToStringMap.remove(generalQuest);
        runningQuestFromStringMap.remove(key);
        MessageQuestVisual message = new MessageQuestVisual(key, null);
        message.setTypeID(2);
        RunningSubscriptionHandler.sendToAll(message);
        return wasRunning;
    }

    public static void questUpdated(GeneralQuest q) {
        String identifier = runningQuestToStringMap.get(q);
        if (q == null || identifier == null) {
            return;
        }
        MessageQuestVisual message = new MessageQuestVisual(identifier, q.getRunningInformation());
        message.setTypeID(2);
        RunningSubscriptionHandler.sendToAll(message);
    }

    public static class PlayerConnectionHandler {
        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent logIn) {
            EntityPlayerMP playerMP = (EntityPlayerMP)logIn.player;
            PacketPipeline.networkPipe.sendTo((IMessage)new MessageQuestScreenInit(MHFCQuestBuildRegistry.groupMapping, MHFCQuestBuildRegistry.groupIDs), playerMP);
            RunningSubscriptionHandler.subscribers.add(playerMP);
            RunningSubscriptionHandler.sendAllTo(playerMP);
        }

        @SubscribeEvent
        public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent logOut) {
            GeneralQuest q = playerQuest.get(logOut.player);
            if (q == null) {
                return;
            }
            q.removePlayer(logOut.player);
            RunningSubscriptionHandler.subscribers.remove(logOut.player);
        }
    }

    public static class RunningSubscriptionHandler
    implements IMessageHandler<MessageQuestRunningSubscription, IMessage> {
        private static Set<EntityPlayerMP> subscribers = new HashSet<EntityPlayerMP>();

        public IMessage onMessage(MessageQuestRunningSubscription message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.isSubscribed()) {
                subscribers.add(player);
                RunningSubscriptionHandler.sendAllTo(player);
            } else {
                subscribers.remove(player);
            }
            return null;
        }

        public static void sendAllTo(EntityPlayerMP player) {
            for (GeneralQuest q : questsRunning) {
                String identifier = runningQuestToStringMap.get(q);
                MessageQuestVisual messageSent = new MessageQuestVisual(identifier, q.getRunningInformation());
                messageSent.setTypeID(2);
                PacketPipeline.networkPipe.sendTo((IMessage)messageSent, player);
            }
        }

        public static void sendToAll(MessageQuestVisual visual) {
            Iterator<EntityPlayerMP> iter = subscribers.iterator();
            while (iter.hasNext()) {
                PacketPipeline.networkPipe.sendTo((IMessage)visual, iter.next());
            }
        }
    }

    public static class RegistryRequestVisualHandler
    implements IMessageHandler<MessageRequestQuestVisual, MessageQuestVisual> {
        public MessageQuestVisual onMessage(MessageRequestQuestVisual message, MessageContext ctx) {
            String identifier = message.getIdentifier();
            QuestDescription description = MHFCQuestBuildRegistry.getQuestDescription(identifier);
            QuestVisualInformation info = description == null ? QuestVisualInformation.IDENTIFIER_ERROR : description.getVisualInformation();
            String[] stringArray = new String[]{identifier, info.getName(), info.getDescription(), info.getClient(), info.getAims(), info.getFails(), info.getAreaID(), info.getTimeLimitAsString(), info.getType().getAsString(), info.getRewardString(), info.getFeeString(), info.getMaxPartySize()};
            return new MessageQuestVisual(stringArray);
        }
    }
}

