/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.entity.monster;

import com.github.worldsender.mcanm.client.model.mcanmmodel.animation.IAnimation;
import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RenderPassInformation;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import mhfc.net.common.ai.AIFollowUpActionManager;
import mhfc.net.common.ai.IActionRecorder;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.entity.nargacuga.NargacugaPounce;
import mhfc.net.common.ai.entity.nargacuga.NargacugaRoar;
import mhfc.net.common.ai.entity.nargacuga.ProwlerStance;
import mhfc.net.common.ai.entity.nargacuga.TailSlam;
import mhfc.net.common.entity.type.EntityMHFCBase;
import mhfc.net.common.entity.type.EntityMHFCPart;
import mhfc.net.common.entity.type.IEnragable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class EntityNargacuga
extends EntityMHFCBase<EntityNargacuga>
implements IActionRecorder<EntityNargacuga>,
IEnragable {
    public static final int EYES_RECORD_LENGTH = 30;
    public static final int EYES_RECORD_FREQUENCY = 10;
    private IActionRecorder.RecorderAdapter<EntityNargacuga> recorder;
    private Queue<Vec3> eyesPositionsRight;
    private Queue<Vec3> eyesPositionsLeft;
    private int ticksSinceEyesSaved;
    private boolean enraged;

    public EntityNargacuga(World world) {
        super(world);
        this.func_70105_a(4.0f, 5.0f);
        this.recorder = new IActionRecorder.RecorderAdapter(100);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.eyesPositionsRight = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)30));
        this.eyesPositionsLeft = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)30));
        this.ticksSinceEyesSaved = 0;
        this.enraged = false;
        AIFollowUpActionManager<EntityNargacuga> attackManager = new AIFollowUpActionManager<EntityNargacuga>(this);
        TailSlam tailSlam = new TailSlam();
        NargacugaRoar roar = new NargacugaRoar();
        ProwlerStance prowler = new ProwlerStance();
        NargacugaPounce pounce = NargacugaPounce.createNargaPounce();
        ArrayList prowlerFollow = new ArrayList();
        prowlerFollow.add(pounce);
        attackManager.registerAttack(tailSlam);
        attackManager.registerAttack(roar);
        attackManager.registerAttack(prowler, prowlerFollow);
        this.setAIActionManager(attackManager);
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.healthbaseHP(9000.0, 13888.0, 18465.0));
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.43);
    }

    @Override
    public EntityMHFCPart[] getParts() {
        return null;
    }

    @Override
    public RenderPassInformation preRenderCallback(float scale, RenderPassInformation sub) {
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        return super.preRenderCallback(scale, sub);
    }

    private Vec3 getRelativePositionOfBone(String name) {
        int frame = this.getCurrentFrame();
        IAnimation animation = this.getAttackManager().getCurrentAnimation();
        if (animation == null) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        IAnimation.BoneTransformation boneTrans = animation.getCurrentTransformation(name, (float)frame);
        if (boneTrans == null) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        Matrix4f transform = boneTrans.asMatrix();
        Vec3 relativePosition = Vec3.func_72443_a((double)transform.m03, (double)transform.m13, (double)transform.m23);
        return relativePosition;
    }

    private Vec3 getPositionLeftEye() {
        Vec3 relativePosition = this.getRelativePositionOfBone("Eye.L");
        return relativePosition.func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private Vec3 getPositionRightEye() {
        Vec3 relativePosition = this.getRelativePositionOfBone("Eye.R");
        return relativePosition.func_72441_c(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public Queue<Vec3> getEyesPositionsRight() {
        return this.eyesPositionsRight;
    }

    public Queue<Vec3> getEyesPositionsLeft() {
        return this.eyesPositionsLeft;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (++this.ticksSinceEyesSaved >= 10) {
            this.ticksSinceEyesSaved = 0;
            this.eyesPositionsLeft.add(this.getPositionLeftEye());
            this.eyesPositionsRight.add(this.getPositionRightEye());
        }
    }

    @Override
    public void onAttackEnd(IExecutableAction<? super EntityNargacuga> oldAttack) {
        this.recorder.addAction(oldAttack);
    }

    @Override
    public List<IExecutableAction<? super EntityNargacuga>> getActionHistory() {
        return this.recorder.getActionHistory();
    }

    @Override
    public IExecutableAction<? super EntityNargacuga> getLastAction() {
        return this.recorder.getLastAction();
    }

    @Override
    public boolean isEnraged() {
        return this.enraged;
    }
}

