/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.entity.projectile;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mhfc.net.common.util.gui.MHFCGuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class EntityFlashBomb
extends EntityThrowable {
    public static final int EXPLOSIVE_TIMER = 40;
    public static final int EXPLOSION_DURATION = 90;
    public static final int PHASE_IN_DURATION = 5;
    public static final int FALL_OFF_BEGIN = 90;
    public static final int FALL_OFF_END = 200;
    private int ticksToExplode = 40;
    private boolean exploded = false;
    private boolean done = false;
    private boolean registered = false;
    private float alphaMultiplier = 1.0f;

    public EntityFlashBomb(World par1World, double x, double y, double z) {
        super(par1World, x, y, z);
    }

    public EntityFlashBomb(World par1World) {
        super(par1World);
    }

    public EntityFlashBomb(World par1World, EntityLivingBase thrower) {
        super(par1World, thrower);
    }

    protected void func_70184_a(MovingObjectPosition var1) {
        this.explode();
    }

    public void func_70030_z() {
        super.func_70030_z();
        --this.ticksToExplode;
        if (this.ticksToExplode == 0) {
            this.explode();
        }
        if (this.exploded) {
            this.func_70016_h(0.0, 0.0, 0.0);
            if (this.ticksToExplode < -90) {
                this.finishExplosion();
            }
        }
    }

    private void finishExplosion() {
        this.done = true;
        this.func_70106_y();
    }

    public void func_70106_y() {
        if (this.registered) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
        super.func_70106_y();
    }

    private void explode() {
        if (this.exploded) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            float viewX = (float)(-Math.sin((double)player.field_70177_z * Math.PI / 180.0));
            float viewZ = (float)Math.cos((double)player.field_70177_z * Math.PI / 180.0);
            float viewY = (float)Math.sin((double)player.field_70125_A * Math.PI / 180.0);
            Vector3f viewVec = new Vector3f(viewX, viewY, viewZ);
            Vector3f dirVec = new Vector3f((float)(this.field_70165_t - player.field_70165_t), (float)(this.field_70163_u - player.field_70163_u), (float)(this.field_70161_v - player.field_70161_v));
            this.alphaMultiplier = this.getAlphaMultiplier(viewVec, dirVec);
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
        this.exploded = true;
        this.ticksToExplode = 0;
    }

    private float getAlphaMultiplier(Vector3f viewDirection, Vector3f entityDirection) {
        float distance = entityDirection.length();
        double angle = this.getAngle(viewDirection, entityDirection);
        if (angle > 0.5 || distance > 200.0f) {
            return 0.0f;
        }
        float distanceMult = 1.0f;
        if (distance > 90.0f) {
            distanceMult -= (distance - 90.0f) / 110.0f;
        }
        if (angle < 0.25) {
            return distanceMult;
        }
        return (float)((0.25 - (angle -= 0.25)) * (0.25 - angle)) * 16.0f * distanceMult;
    }

    private float getAngle(Vector3f viewDirection, Vector3f entityDirection) {
        float dot = Vector3f.dot((Vector3f)viewDirection, (Vector3f)entityDirection);
        float lengthProd = viewDirection.length() * entityDirection.length();
        dot = Math.abs(dot / lengthProd);
        return (float)(Math.acos(dot) / Math.PI);
    }

    @SubscribeEvent
    public void onGuiDraw(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && this.exploded && !this.done && mc != null) {
            float alpha = this.getAlphaFromExplosionDuration(-this.ticksToExplode) * this.alphaMultiplier;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int screenWidth = MHFCGuiUtil.minecraftWidth(mc);
            int screenHeight = MHFCGuiUtil.minecraftHeight(mc);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)7);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)50.0f);
            GL11.glVertex3f((float)0.0f, (float)screenHeight, (float)50.0f);
            GL11.glVertex3f((float)screenWidth, (float)screenHeight, (float)50.0f);
            GL11.glVertex3f((float)screenWidth, (float)0.0f, (float)50.0f);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
    }

    private float getAlphaFromExplosionDuration(int dur) {
        if (dur < 0 || dur > 90) {
            return 0.0f;
        }
        if (dur < 5) {
            return (float)(dur + 1) / 5.0f;
        }
        float phaseOutDuration = 85.0f;
        return (phaseOutDuration - (float)(dur -= 5)) / phaseOutDuration;
    }
}

