/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.entity.type;

import com.github.worldsender.mcanm.client.model.mcanmmodel.data.RenderPassInformation;
import com.github.worldsender.mcanm.client.renderer.IAnimatedObject;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mhfc.net.common.ai.AIActionManager;
import mhfc.net.common.ai.IExecutableAction;
import mhfc.net.common.ai.IManagedActions;
import mhfc.net.common.ai.general.AIUtils;
import mhfc.net.common.ai.general.TargetTurnHelper;
import mhfc.net.common.entity.type.EntityMHFCPart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityMHFCBase<YC extends EntityMHFCBase<YC>>
extends EntityCreature
implements IEntityMultiPart,
IAnimatedObject,
IManagedActions<YC> {
    protected static final int DATA_FRAME = 12;
    private final TargetTurnHelper turnHelper = new TargetTurnHelper(this);
    private AIActionManager<YC> attackManager = new AIActionManager<EntityMHFCBase>(this);

    public EntityMHFCBase(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, this.attackManager);
    }

    public abstract EntityMHFCPart[] getParts();

    public void dropItemRand(Item item, int count) {
        this.dropItemRand(new ItemStack(item, count, 0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)-1);
    }

    public void dropItemRand(ItemStack stack) {
        Random rand = this.field_70170_p.field_73012_v;
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)rand.nextInt(10) - 5.0, this.field_70163_u + 1.0, this.field_70161_v + (double)rand.nextInt(10) - 5.0, stack);
        this.field_70170_p.func_72838_d((Entity)entityItem);
    }

    public double healthbaseHP(double lowhp, double medhp, double highhp) {
        if (this.field_70146_Z.nextInt(60) == 0) {
            return medhp;
        }
        if (this.field_70146_Z.nextInt(120) == 0) {
            return highhp;
        }
        if (this.field_70146_Z.nextInt(80) == 0) {
            return lowhp;
        }
        return medhp;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70091_d(double currOffX, double currOffY, double currOffZ) {
        if (this.field_70145_X) {
            this.offsetEntity(currOffX, currOffY, currOffZ);
        } else {
            boolean landed;
            double originalOffX = currOffX;
            double originalOffY = currOffY;
            double originalOffZ = currOffZ;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                currOffX *= 0.25;
                currOffY *= (double)0.05f;
                currOffZ *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double correctedOffX = currOffX;
            double correctedOffY = currOffY;
            double correctedOffZ = currOffZ;
            EntityMHFCPart[] parts = this.getParts();
            if (parts == null) {
                parts = new EntityMHFCPart[]{};
            }
            List bbsInWay = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(currOffX, currOffY, currOffZ));
            for (AxisAlignedBB bb : bbsInWay) {
                currOffY = bb.func_72323_b(this.field_70121_D, currOffY);
            }
            for (AxisAlignedBB bb : bbsInWay) {
                currOffX = bb.func_72316_a(this.field_70121_D, currOffX);
            }
            for (AxisAlignedBB bb : bbsInWay) {
                currOffZ = bb.func_72322_c(this.field_70121_D, currOffZ);
            }
            for (EntityMHFCPart part : parts) {
                List bbsInWayPart = this.field_70170_p.func_72945_a((Entity)this, part.field_70121_D.func_72321_a(currOffX, currOffY, currOffZ));
                for (AxisAlignedBB bb : bbsInWayPart) {
                    currOffY = bb.func_72323_b(part.field_70121_D, currOffY);
                }
                for (AxisAlignedBB bb : bbsInWayPart) {
                    currOffX = bb.func_72316_a(part.field_70121_D, currOffX);
                }
                for (AxisAlignedBB bb : bbsInWayPart) {
                    currOffZ = bb.func_72322_c(part.field_70121_D, currOffZ);
                }
            }
            boolean bl = landed = this.field_70122_E || correctedOffY != currOffY && correctedOffY < 0.0;
            if (this.field_70138_W > 0.0f && landed && this.field_70139_V < 0.125f && (correctedOffX != currOffX || correctedOffZ != currOffZ)) {
                double nostepOffX = currOffX;
                double nostepOffY = currOffY;
                double nostepOffZ = currOffZ;
                currOffX = correctedOffX;
                currOffY = this.field_70138_W;
                currOffZ = correctedOffZ;
                List bbsInStepup = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(correctedOffX, currOffY, correctedOffZ));
                for (AxisAlignedBB bb : bbsInStepup) {
                    currOffY = bb.func_72323_b(this.field_70121_D, currOffY);
                }
                for (AxisAlignedBB bb : bbsInStepup) {
                    currOffX = bb.func_72316_a(this.field_70121_D, currOffX);
                }
                for (AxisAlignedBB bb : bbsInStepup) {
                    currOffZ = bb.func_72322_c(this.field_70121_D, currOffZ);
                }
                for (EntityMHFCPart part : parts) {
                    List bbsInStepupPart = this.field_70170_p.func_72945_a((Entity)this, part.field_70121_D.func_72321_a(currOffX, currOffY, currOffZ));
                    for (AxisAlignedBB bb : bbsInStepupPart) {
                        currOffY = bb.func_72323_b(part.field_70121_D, currOffY);
                    }
                    for (AxisAlignedBB bb : bbsInStepupPart) {
                        currOffX = bb.func_72316_a(part.field_70121_D, currOffX);
                    }
                    for (AxisAlignedBB bb : bbsInStepupPart) {
                        currOffZ = bb.func_72322_c(part.field_70121_D, currOffZ);
                    }
                }
                double groundOffY = -this.field_70138_W;
                for (AxisAlignedBB bb : bbsInStepup) {
                    groundOffY = bb.func_72323_b(this.field_70121_D.func_72325_c(currOffX, currOffY, currOffZ), groundOffY);
                }
                for (EntityMHFCPart part : parts) {
                    List bbsInStepDown = this.field_70170_p.func_72945_a((Entity)this, part.field_70121_D.func_72321_a(currOffX, currOffY, currOffZ));
                    for (AxisAlignedBB bb : bbsInStepDown) {
                        currOffY = bb.func_72323_b(part.field_70121_D, currOffY);
                    }
                }
                currOffY += groundOffY;
                if (nostepOffX * nostepOffX + nostepOffY * nostepOffY >= currOffX * currOffX + currOffZ * currOffZ) {
                    currOffX = nostepOffX;
                    currOffY = nostepOffY;
                    currOffZ = nostepOffZ;
                }
            }
            double originalX = this.field_70165_t;
            double originalY = this.field_70163_u;
            double originalZ = this.field_70161_v;
            AxisAlignedBB originalBB = this.field_70121_D.func_72329_c();
            super.func_70091_d(originalOffX, originalOffY, originalOffZ);
            this.field_70165_t = originalX;
            this.field_70163_u = originalY;
            this.field_70161_v = originalZ;
            this.field_70121_D.func_72328_c(originalBB);
            this.offsetEntity(currOffX, currOffY, currOffZ);
        }
    }

    private void offsetEntity(double offX, double offY, double offZ) {
        this.field_70121_D.func_72317_d(offX, offY, offZ);
        this.field_70165_t += offX;
        this.field_70163_u += offY;
        this.field_70161_v += offZ;
        EntityMHFCPart[] parts = this.getParts();
        if (parts == null) {
            return;
        }
        for (EntityMHFCPart part : parts) {
            part.offsetEntity(offX, offY, offZ);
        }
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected AIActionManager<YC> getAIActionManager() {
        return this.attackManager;
    }

    protected void setAIActionManager(AIActionManager<YC> newManager) {
        Objects.requireNonNull(newManager);
        this.field_70714_bg.func_85156_a(this.attackManager);
        this.attackManager = newManager;
        this.field_70714_bg.func_75776_a(0, newManager);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70629_bd() {
        super.func_70629_bd();
        this.setFrame(this.attackManager.getCurrentFrame());
        this.turnHelper.onUpdateTurn();
    }

    public void setFrame(int newframe) {
        this.field_70180_af.func_75692_b(12, (Object)newframe);
    }

    public boolean func_70965_a(EntityDragonPart part, DamageSource damageSource, float damageValue) {
        return false;
    }

    @Override
    public AIActionManager<YC> getAttackManager() {
        return this.attackManager;
    }

    protected int getCurrentFrame() {
        return this.field_70180_af.func_75679_c(12);
    }

    public RenderPassInformation preRenderCallback(float subFrame, RenderPassInformation passInfo) {
        return passInfo.setAnimation(this.attackManager.getCurrentAnimation()).setFrame((float)this.getCurrentFrame() + subFrame);
    }

    @Override
    public void onAttackEnd(IExecutableAction<? super YC> oldAttack) {
        this.setFrame(-1);
    }

    @Override
    public void onAttackStart(IExecutableAction<? super YC> newAttack) {
        if (newAttack != null) {
            this.setFrame(0);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public TargetTurnHelper getTurnHelper() {
        return this.turnHelper;
    }

    public void moveForward(double movementSpeed, boolean makeStep) {
        Vec3 view = this.func_70040_Z();
        float effectiveSpeed = (float)(movementSpeed * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        Vec3 forwardVector = Vec3.func_72443_a((double)(view.field_72450_a * (double)effectiveSpeed), (double)this.field_70181_x, (double)(view.field_72449_c * (double)effectiveSpeed));
        boolean jump = false;
        if (makeStep) {
            AxisAlignedBB bounds = this.field_70121_D.func_72325_c(0.0, 0.0, 0.0);
            bounds.func_72317_d(forwardVector.field_72450_a, 0.0, forwardVector.field_72449_c);
            List<AxisAlignedBB> normalPathCollision = AIUtils.gatherOverlappingBounds(bounds, (Entity)this);
            bounds.func_72317_d(0.0, (double)this.field_70138_W, 0.0);
            List<AxisAlignedBB> jumpPathCollision = AIUtils.gatherOverlappingBounds(bounds, (Entity)this);
            if (!normalPathCollision.isEmpty() && jumpPathCollision.isEmpty()) {
                jump = true;
            }
        }
        if (jump) {
            this.func_70091_d(0.0, (double)this.field_70138_W + 0.5, 0.0);
            this.field_70181_x = 0.0;
            this.field_70160_al = true;
        }
        this.func_70016_h(forwardVector.field_72450_a, forwardVector.field_72448_b, forwardVector.field_72449_c);
    }
}

