/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.eventhandler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import mhfc.net.common.network.packet.MessageMHFCInteraction;
import net.minecraft.entity.player.EntityPlayerMP;

public class MHFCInteractionHandler
implements IMessageHandler<MessageMHFCInteraction, IMessage> {
    public IMessage onMessage(MessageMHFCInteraction message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        switch (message.getInteraction()) {
            case NEW_QUEST: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionNewQuestEvent(player, message));
                break;
            }
            case ACCEPT_QUEST: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionAcceptQuestEvent(player, message));
                break;
            }
            case START_QUEST: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionStartQuestEvent(player, message));
                break;
            }
            case END_QUEST: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionEndQuestEvent(player, message));
                break;
            }
            case FORFEIT_QUEST: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionForfeitQuestEvent(player, message));
                break;
            }
            case MOD_RELOAD: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionModReloadEvent(player, message));
                break;
            }
            default: {
                FMLCommonHandler.instance().bus().post((Event)new MHFCInteractionEvent(player, message, MessageMHFCInteraction.Interaction.INVALID));
            }
        }
        return null;
    }

    public static class MHFCInteractionModReloadEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionModReloadEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.MOD_RELOAD);
        }
    }

    public static class MHFCInteractionForfeitQuestEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionForfeitQuestEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.FORFEIT_QUEST);
        }
    }

    public static class MHFCInteractionEndQuestEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionEndQuestEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.END_QUEST);
        }
    }

    public static class MHFCInteractionStartQuestEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionStartQuestEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.START_QUEST);
        }
    }

    public static class MHFCInteractionAcceptQuestEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionAcceptQuestEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.ACCEPT_QUEST);
        }
    }

    public static class MHFCInteractionNewQuestEvent
    extends MHFCInteractionEvent {
        public MHFCInteractionNewQuestEvent(EntityPlayerMP player, MessageMHFCInteraction message) {
            super(player, message, MessageMHFCInteraction.Interaction.NEW_QUEST);
        }
    }

    @Cancelable
    public static class MHFCInteractionEvent
    extends Event {
        public EntityPlayerMP player;
        public MessageMHFCInteraction message;
        public MessageMHFCInteraction.Interaction interaction;

        public MHFCInteractionEvent(EntityPlayerMP player, MessageMHFCInteraction message, MessageMHFCInteraction.Interaction interaction) {
            this.player = player;
            this.message = message;
            this.interaction = interaction;
        }
    }
}

