/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.eventhandler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mhfc.net.common.eventhandler.MHFCDelayedJob;

public class MHFCJobHandler {
    public static final int ticksPerSecond = 50;
    public static final MHFCJobHandler instance = new MHFCJobHandler();
    private volatile JobListElement startOfList;
    private List<MHFCDelayedJob> listOfRemoves = new Vector<MHFCDelayedJob>();

    public static MHFCJobHandler instance() {
        return instance;
    }

    private MHFCJobHandler() {
        this.startOfList = new JobListEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void receiveTick(TickEvent.ClientTickEvent tick) {
        MHFCJobHandler mHFCJobHandler = this;
        synchronized (mHFCJobHandler) {
            this.cleanUp();
            this.startOfList = this.startOfList.tick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void receiveTick(TickEvent.ServerTickEvent tick) {
        MHFCJobHandler mHFCJobHandler = this;
        synchronized (mHFCJobHandler) {
            this.cleanUp();
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                this.startOfList = this.startOfList.tick();
            }
        }
    }

    private synchronized void cleanUp() {
        for (MHFCDelayedJob job : this.listOfRemoves) {
            this.startOfList.remove(job);
        }
        this.listOfRemoves.clear();
    }

    public void insert(MHFCDelayedJob job, int delay) {
        if (delay >= 0) {
            this.startOfList = this.startOfList.insert(job, delay);
        }
    }

    public void remove(MHFCDelayedJob job) {
        this.listOfRemoves.add(job);
    }

    public boolean containsJob(MHFCDelayedJob job) {
        return this.startOfList.containsJob(job);
    }

    public int getDelay(MHFCDelayedJob job) {
        return this.startOfList.getDelay(job);
    }

    public int getMaxDelay() {
        return this.startOfList.maxQueue();
    }

    private class JobListEnd
    extends JobListElement {
        private JobListEnd() {
        }

        @Override
        public JobListElement insert(MHFCDelayedJob job, int delay) {
            return new DelayedJob(job, delay, this);
        }

        @Override
        public JobListElement tick() {
            return this;
        }

        @Override
        public int getDelay(MHFCDelayedJob job) {
            return -1;
        }

        @Override
        public void remove(MHFCDelayedJob job) {
        }

        @Override
        public boolean containsJob(MHFCDelayedJob job) {
            return false;
        }

        @Override
        public int queueLength() {
            return 0;
        }

        @Override
        public int maxQueue() {
            return 0;
        }
    }

    private class DelayedJob
    extends JobListElement {
        private volatile List<MHFCDelayedJob> jobs;
        private volatile JobListElement following;
        private volatile int ticksToExecution;

        public DelayedJob(MHFCDelayedJob initialJob, int delay, JobListElement following) {
            if (initialJob == null) {
                throw new IllegalArgumentException("Initial job may not be null");
            }
            this.jobs = new Vector<MHFCDelayedJob>();
            this.ticksToExecution = delay;
            this.jobs.add(initialJob);
            this.following = following;
        }

        @Override
        public synchronized JobListElement insert(MHFCDelayedJob job, int delay) {
            if (delay > this.ticksToExecution) {
                this.following = this.following.insert(job, delay - this.ticksToExecution);
                return this;
            }
            if (delay == this.ticksToExecution) {
                this.jobs.add(job);
                return this;
            }
            this.ticksToExecution -= delay;
            return new DelayedJob(job, delay, this);
        }

        @Override
        public synchronized JobListElement tick() {
            --this.ticksToExecution;
            if (this.ticksToExecution == 0) {
                Iterator<MHFCDelayedJob> iter = this.jobs.iterator();
                while (iter.hasNext()) {
                    iter.next().executeJob();
                }
                this.jobs.clear();
                return this.following.tick();
            }
            if (this.ticksToExecution < 0) {
                return this.following.tick();
            }
            return this;
        }

        @Override
        public int getDelay(MHFCDelayedJob job) {
            if (this.jobs.contains(job)) {
                return this.ticksToExecution;
            }
            int a = this.following.getDelay(job);
            return a < 0 ? -1 : this.ticksToExecution + a;
        }

        @Override
        public synchronized void remove(MHFCDelayedJob job) {
            this.jobs.remove(job);
            this.following.remove(job);
        }

        @Override
        public boolean containsJob(MHFCDelayedJob job) {
            return this.jobs.contains(job) || this.following.containsJob(job);
        }

        @Override
        public int queueLength() {
            return 1 + this.following.queueLength();
        }

        @Override
        public int maxQueue() {
            return this.ticksToExecution + this.following.maxQueue();
        }
    }

    private abstract class JobListElement {
        private JobListElement() {
        }

        public abstract JobListElement insert(MHFCDelayedJob var1, int var2);

        public abstract JobListElement tick();

        public abstract int getDelay(MHFCDelayedJob var1);

        public abstract void remove(MHFCDelayedJob var1);

        public abstract boolean containsJob(MHFCDelayedJob var1);

        public abstract int queueLength();

        public abstract int maxQueue();
    }
}

