/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mhfc.net.MHFCMain;
import mhfc.net.client.model.armor.ModelDragoonArmor;
import mhfc.net.common.core.registry.MHFCItemRegistry;
import mhfc.net.common.helper.MHFCArmorMaterialHelper;
import mhfc.net.common.helper.MHFCArmorModelHelper;
import mhfc.net.common.system.ColorSystem;
import mhfc.net.common.system.DonatorSystem;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class DragoonArmor
extends ItemArmor {
    private static final String[] names = new String[]{"f.mhf_helm", "f.mhf_chest", "f.mhf_leg", "f.mhf_boots"};
    private static final String[] icons = new String[]{"mhfc:mhf_0", "mhfc:mhf_1", "mhfc:mhf_2", "mhfc:mhf_3"};

    public DragoonArmor(int type) {
        super(MHFCArmorMaterialHelper.ArmorDragoon, 4, type);
        this.func_77637_a(MHFCMain.mhfctabs);
        this.func_77655_b(names[type]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(icons[this.field_77881_a]);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(ColorSystem.ENUMRED + "Exclusive " + "[ " + ColorSystem.ENUMGOLD + " DONATORS  " + ColorSystem.ENUMRED + "]");
        par3List.add("Health +1");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (!(entity instanceof EntityPlayer) || stack == null) {
            return "mhfc:textures/armor/null.png";
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!DonatorSystem.checkDragoon(player)) {
            return "mhfc:textures/armor/null.png";
        }
        if (stack.func_77973_b() == MHFCItemRegistry.armor_dragoon_helm || stack.func_77973_b() == MHFCItemRegistry.armor_dragoon_chest || stack.func_77973_b() == MHFCItemRegistry.armor_dragoon_boots) {
            return "mhfc:textures/armor/dragoon_layer_1.png";
        }
        if (stack.func_77973_b() == MHFCItemRegistry.armor_dragoon_legs) {
            return "mhfc:textures/armor/dragoon_layer_2.png";
        }
        return "mhfc:textures/armor/null.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelDragoonArmor armorModel = null;
        if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemArmor)) {
            return null;
        }
        int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        if (type == 1 || type == 3 || type == 0) {
            armorModel = MHFCArmorModelHelper.dragoon;
        }
        if (armorModel == null) {
            return null;
        }
        armorModel.field_78116_c.field_78806_j = armorSlot == 0;
        armorModel.field_78114_d.field_78806_j = armorSlot == 0;
        armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
        armorModel.field_78112_f.field_78806_j = armorSlot == 1;
        armorModel.field_78113_g.field_78806_j = armorSlot == 1;
        armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
        armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
        armorModel.field_78117_n = entityLiving.func_70093_af();
        armorModel.field_78093_q = entityLiving.func_70115_ae();
        armorModel.field_78091_s = entityLiving.func_70631_g_();
        armorModel.field_78120_m = 0;
        armorModel.field_78118_o = false;
        ItemStack held_item = entityLiving.func_71124_b(0);
        if (held_item != null) {
            armorModel.field_78120_m = 1;
            if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71052_bv() > 0) {
                EnumAction enumaction = held_item.func_77975_n();
                if (enumaction == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                } else if (enumaction == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                }
            }
        }
        return armorModel;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        float h = player.func_110143_aJ();
        if (this.field_77881_a != 0) {
            return;
        }
        ItemStack boots = player.func_82169_q(0);
        ItemStack legs = player.func_82169_q(1);
        ItemStack chest = player.func_82169_q(2);
        if (chest != null && legs != null && boots != null && chest.func_77973_b() == MHFCItemRegistry.armor_dragoon_chest && boots.func_77973_b() == MHFCItemRegistry.armor_dragoon_boots && legs.func_77973_b() == MHFCItemRegistry.armor_dragoon_legs) {
            if (!DonatorSystem.checkDragoon(player)) {
                return;
            }
            player.func_82170_o(21);
            player.func_70690_d(new PotionEffect(21, 200, 1, true));
            player.func_70606_j(h);
        }
    }

    public int getHealthBoost(int slot) {
        if (slot == 3) {
            return 1;
        }
        if (slot == 2) {
            return 2;
        }
        if (slot == 1) {
            return 1;
        }
        return 1;
    }
}

