/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.network.message.bench;

import io.netty.buffer.ByteBuf;
import mhfc.net.common.core.registry.MHFCEquipementRecipeRegistry;
import mhfc.net.common.crafting.recipes.equipment.EquipmentRecipe;
import mhfc.net.common.item.ItemType;
import mhfc.net.common.network.packet.MessageTileLocation;
import mhfc.net.common.tile.TileHunterBench;

public class MessageSetRecipe
extends MessageTileLocation {
    private EquipmentRecipe.RecipeType recipeTypeID;
    private ItemType outputTypeID;
    private int recipeID;

    public MessageSetRecipe() {
    }

    public MessageSetRecipe(TileHunterBench bench, EquipmentRecipe r) {
        super(bench);
        if (r != null) {
            this.recipeTypeID = r.getRecipeType();
            this.outputTypeID = r.getOutputType();
            this.recipeID = MHFCEquipementRecipeRegistry.getIDFor(r);
        } else {
            this.recipeTypeID = EquipmentRecipe.RecipeType.MHFC;
            this.outputTypeID = ItemType.NO_OTHER;
            this.recipeID = -1;
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.recipeTypeID = EquipmentRecipe.RecipeType.values()[buf.readInt()];
        this.outputTypeID = ItemType.values()[buf.readInt()];
        this.recipeID = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.recipeTypeID.ordinal());
        buf.writeInt(this.outputTypeID.ordinal());
        buf.writeInt(this.recipeID);
    }

    public int getRecipeID() {
        return this.recipeID;
    }

    public EquipmentRecipe.RecipeType getRecipeType() {
        return this.recipeTypeID;
    }

    public ItemType getOutputType() {
        return this.outputTypeID;
    }
}

