/*
 * Decompiled with CFR 0.152.
 */
package mhfc.net.common.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;

public class MessageMHFCInteraction
implements IMessage {
    protected Interaction interaction;
    protected String[] options;

    public MessageMHFCInteraction() {
    }

    public MessageMHFCInteraction(Interaction action, String ... options) {
        this.interaction = action;
        this.options = options;
    }

    public void toBytes(ByteBuf buf) {
        try (ByteBufOutputStream out = new ByteBufOutputStream(buf);){
            int toWrite;
            switch (this.interaction) {
                case NEW_QUEST: {
                    toWrite = 0;
                    break;
                }
                case ACCEPT_QUEST: {
                    toWrite = 1;
                    break;
                }
                case START_QUEST: {
                    toWrite = 2;
                    break;
                }
                case END_QUEST: {
                    toWrite = 3;
                    break;
                }
                case FORFEIT_QUEST: {
                    toWrite = 4;
                    break;
                }
                default: {
                    toWrite = -1;
                }
            }
            out.writeByte(toWrite);
            out.writeByte(this.options.length);
            for (String s : this.options) {
                out.writeUTF(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fromBytes(ByteBuf buf) {
        try (ByteBufInputStream in = new ByteBufInputStream(buf);){
            byte b = in.readByte();
            switch (b) {
                case 0: {
                    this.interaction = Interaction.NEW_QUEST;
                    break;
                }
                case 1: {
                    this.interaction = Interaction.ACCEPT_QUEST;
                    break;
                }
                case 2: {
                    this.interaction = Interaction.START_QUEST;
                    break;
                }
                case 3: {
                    this.interaction = Interaction.END_QUEST;
                    break;
                }
                case 4: {
                    this.interaction = Interaction.FORFEIT_QUEST;
                    break;
                }
                default: {
                    this.interaction = Interaction.INVALID;
                }
            }
            b = in.readByte();
            this.options = new String[b];
            for (byte a = 0; a < b; a = (byte)(a + 1)) {
                this.options[a] = in.readUTF();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    public String[] getOptions() {
        return this.options;
    }

    public static enum Interaction {
        NEW_QUEST,
        ACCEPT_QUEST,
        START_QUEST,
        END_QUEST,
        FORFEIT_QUEST,
        MOD_RELOAD,
        INVALID;

    }
}

